<?php
$pageTitle = 'Login - OrderFood Portal';
require_once 'config.php';

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (!empty($email) && !empty($password)) {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM users WHERE email = ? AND is_active = 1");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_phone'] = $user['phone'];
            $_SESSION['user_address'] = $user['address'];
            $_SESSION['user_role'] = $user['role'];
            
            setFlash('success', 'Welcome back, ' . $user['name'] . '!');
            
            // Redirect to intended page or home
            $redirect = $_GET['redirect'] ?? 'index.php';
            header('Location: ' . $redirect);
            exit;
        } else {
            setFlash('danger', 'Invalid email or password');
        }
    } else {
        setFlash('danger', 'Please fill in all fields');
    }
}

require_once 'includes/header.php';
?>

<!-- Auth Section -->
<section class="auth-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="auth-card">
                    <div class="row g-0">
                        <!-- Image Side -->
                        <div class="col-lg-6 d-none d-lg-block">
                            <div class="image-side">
                                <i class="bi bi-fire" style="font-size: 80px; margin-bottom: 20px;"></i>
                                <h2>Welcome Back!</h2>
                                <p>Login to access your account, track orders, and enjoy exclusive offers.</p>
                                <img src="https://images.unsplash.com/photo-1504674900247-0877df9cc836?w=400&h=300&fit=crop" alt="Food" class="img-fluid rounded-4 mt-4">
                            </div>
                        </div>
                        
                        <!-- Form Side -->
                        <div class="col-lg-6">
                            <div class="form-side position-relative">
                                <!-- Close Button -->
                                <a href="index.php" class="btn-close-auth" title="Close">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                                
                                <div class="text-center mb-4">
                                    <h3>Login to Your Account</h3>
                                    <p class="text-muted">Enter your credentials to continue</p>
                                </div>
                                
                                <form method="POST" action="">
                                    <div class="form-floating mb-3">
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                                        <label for="email"><i class="bi bi-envelope me-2"></i>Email Address</label>
                                    </div>
                                    
                                    <div class="form-floating mb-3">
                                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                                        <label for="password"><i class="bi bi-lock me-2"></i>Password</label>
                                    </div>
                                    
                                    <div class="d-flex justify-content-between align-items-center mb-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="remember" name="remember">
                                            <label class="form-check-label" for="remember">Remember me</label>
                                        </div>
                                        <a href="#" class="text-primary">Forgot Password?</a>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                                        <i class="bi bi-box-arrow-in-right me-2"></i>Login
                                    </button>
                                    
                                    <div class="text-center">
                                        <span class="text-muted">Don't have an account?</span>
                                        <a href="register.php" class="text-primary fw-bold smooth-link">Sign Up</a>
                                    </div>
                                </form>
                                
                                <hr class="my-4">
                                
                                <div class="text-center">
                                    <p class="text-muted mb-3">Or continue with</p>
                                    <div class="d-flex gap-3 justify-content-center">
                                        <button class="btn btn-outline-secondary px-4">
                                            <i class="bi bi-google"></i>
                                        </button>
                                        <button class="btn btn-outline-secondary px-4">
                                            <i class="bi bi-facebook"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>

