<?php
$pageTitle = 'OrderFood Portal - Delicious Food Delivered Fresh';
require_once 'config.php';

$db = getDB();

// Get featured items
$featuredQuery = $db->query("SELECT m.*, c.name as category_name FROM menu_items m JOIN categories c ON m.category_id = c.id WHERE m.is_featured = 1 AND m.is_available = 1 LIMIT 8");
$featuredItems = $featuredQuery->fetchAll(PDO::FETCH_ASSOC);

// Get categories
$categoriesQuery = $db->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY sort_order");
$categories = $categoriesQuery->fetchAll(PDO::FETCH_ASSOC);

require_once 'includes/header.php';
?>

<!-- Hero Section -->
<section class="hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="hero-content" data-aos="fade-right">
                    <span>🔥 Fresh & Delicious</span>
                    <h1>Order Your <span class="highlight">Favorite Food</span> Online</h1>
                    <p>From stone-baked pizzas to juicy burgers, we deliver happiness to your doorstep. Fresh ingredients, authentic recipes, and lightning-fast delivery.</p>
                    <div class="hero-buttons">
                        <a href="menu.php" class="btn btn-primary btn-lg">
                            <i class="bi bi-bag-fill me-2"></i>Order Now
                        </a>
                        <a href="#categories" class="btn btn-outline-light btn-lg">
                            <i class="bi bi-grid me-2"></i>View Menu
                        </a>
                    </div>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <h3>500+</h3>
                            <p>Happy Customers</p>
                        </div>
                        <div class="stat-item">
                            <h3>50+</h3>
                            <p>Menu Items</p>
                        </div>
                        <div class="stat-item">
                            <h3>30</h3>
                            <p>Min Delivery</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="hero-image" data-aos="fade-left">
                    <img src="https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?w=600&h=600&fit=crop" alt="Delicious Pizza">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Categories Section -->
<section class="categories" id="categories">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span>Our Menu</span>
            <h2>Browse Categories</h2>
            <p>Choose from our wide variety of delicious food categories</p>
        </div>
        
        <div class="row g-4">
            <?php 
            $icons = ['🍕', '🍔', '🍝', '🥤', '🍰', '🍟'];
            $index = 0;
            foreach ($categories as $category): 
            ?>
            <div class="col-lg-2 col-md-4 col-6" data-aos="fade-up" data-aos-delay="<?= $index * 100 ?>">
                <a href="menu.php?category=<?= $category['id'] ?>" class="category-card">
                    <div class="icon"><?= $icons[$index % count($icons)] ?></div>
                    <h4><?= htmlspecialchars($category['name']) ?></h4>
                    <p><?= htmlspecialchars($category['description'] ?? 'Delicious options') ?></p>
                </a>
            </div>
            <?php $index++; endforeach; ?>
        </div>
    </div>
</section>

<!-- Featured Items -->
<section class="featured">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span>⭐ Popular Choices</span>
            <h2>Featured Items</h2>
            <p>Our most loved dishes, handpicked for you</p>
        </div>
        
        <div class="row g-4">
            <?php foreach ($featuredItems as $index => $item): ?>
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="<?= $index * 50 ?>">
                <div class="food-card">
                    <div class="image">
                        <img src="<?= $item['image'] ? 'uploads/' . htmlspecialchars($item['image']) : 'https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?w=400&h=300&fit=crop' ?>" alt="<?= htmlspecialchars($item['name']) ?>">
                        <div class="badges">
                            <?php if ($item['is_featured']): ?>
                                <span class="badge featured">⭐ Featured</span>
                            <?php endif; ?>
                            <?php if ($item['is_vegetarian']): ?>
                                <span class="badge vegetarian">🥬 Veg</span>
                            <?php endif; ?>
                            <?php if ($item['is_spicy']): ?>
                                <span class="badge spicy">🌶️ Spicy</span>
                            <?php endif; ?>
                            <?php if ($item['discount_price']): ?>
                                <span class="badge discount"><?= round((($item['price'] - $item['discount_price']) / $item['price']) * 100) ?>% OFF</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="content">
                        <span class="category"><?= htmlspecialchars($item['category_name']) ?></span>
                        <h4><?= htmlspecialchars($item['name']) ?></h4>
                        <p class="description"><?= htmlspecialchars($item['description']) ?></p>
                        <div class="footer">
                            <div class="price">
                                <?php if ($item['discount_price']): ?>
                                    <span class="current"><?= formatPrice($item['discount_price']) ?></span>
                                    <span class="original"><?= formatPrice($item['price']) ?></span>
                                <?php else: ?>
                                    <span class="current"><?= formatPrice($item['price']) ?></span>
                                <?php endif; ?>
                            </div>
                            <button class="add-btn add-to-cart" data-item-id="<?= $item['id'] ?>">
                                <i class="bi bi-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-5" data-aos="fade-up">
            <a href="menu.php" class="btn btn-primary btn-lg">
                View Full Menu <i class="bi bi-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Special Offer -->
<section class="special-offer">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6" data-aos="fade-right">
                <div class="offer-content">
                    <span>🎉 Limited Time Offer</span>
                    <h2>Get 20% Off on Your First Order!</h2>
                    <p>Use code <strong>WELCOME20</strong> at checkout and enjoy amazing savings on your favorite meals.</p>
                    <div class="countdown">
                        <div class="countdown-item">
                            <span id="days">07</span>
                            <p>Days</p>
                        </div>
                        <div class="countdown-item">
                            <span id="hours">12</span>
                            <p>Hours</p>
                        </div>
                        <div class="countdown-item">
                            <span id="minutes">45</span>
                            <p>Minutes</p>
                        </div>
                        <div class="countdown-item">
                            <span id="seconds">30</span>
                            <p>Seconds</p>
                        </div>
                    </div>
                    <a href="menu.php" class="btn btn-primary btn-lg">
                        Order Now <i class="bi bi-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <img src="https://images.unsplash.com/photo-1513104890138-7c749659a591?w=600&h=400&fit=crop" alt="Pizza Offer" class="img-fluid rounded-4">
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="py-5">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span>Why Choose Us</span>
            <h2>What Makes Us Special</h2>
        </div>
        
        <div class="row g-4">
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="0">
                <div class="text-center p-4">
                    <div class="mb-3" style="font-size: 50px;">🚀</div>
                    <h5>Fast Delivery</h5>
                    <p class="text-muted">Get your food delivered within 30 minutes</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                <div class="text-center p-4">
                    <div class="mb-3" style="font-size: 50px;">🍳</div>
                    <h5>Fresh Ingredients</h5>
                    <p class="text-muted">We use only the freshest ingredients</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                <div class="text-center p-4">
                    <div class="mb-3" style="font-size: 50px;">👨‍🍳</div>
                    <h5>Expert Chefs</h5>
                    <p class="text-muted">Prepared by experienced master chefs</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                <div class="text-center p-4">
                    <div class="mb-3" style="font-size: 50px;">💰</div>
                    <h5>Best Prices</h5>
                    <p class="text-muted">Quality food at affordable prices</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials -->
<section class="testimonials">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span>Testimonials</span>
            <h2>What Our Customers Say</h2>
        </div>
        
        <div class="row g-4">
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="0">
                <div class="testimonial-card">
                    <div class="quote">"</div>
                    <p>The pizza was absolutely amazing! Fresh, hot, and delivered right on time. Will definitely order again!</p>
                    <div class="author">
                        <img src="https://i.pravatar.cc/100?img=1" alt="Customer">
                        <div>
                            <h5>Ahmed Khan</h5>
                            <span>Regular Customer</span>
                            <div class="rating">
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="100">
                <div class="testimonial-card">
                    <div class="quote">"</div>
                    <p>Best burgers in town! The quality is consistent and the delivery is always fast. Highly recommended!</p>
                    <div class="author">
                        <img src="https://i.pravatar.cc/100?img=5" alt="Customer">
                        <div>
                            <h5>Sara Ali</h5>
                            <span>Food Blogger</span>
                            <div class="rating">
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="200">
                <div class="testimonial-card">
                    <div class="quote">"</div>
                    <p>Love the variety of options and the easy ordering process. The food always arrives fresh and delicious!</p>
                    <div class="author">
                        <img src="https://i.pravatar.cc/100?img=3" alt="Customer">
                        <div>
                            <h5>Usman Malik</h5>
                            <span>Verified Buyer</span>
                            <div class="rating">
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-fill"></i>
                                <i class="bi bi-star-half"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
// Countdown Timer
function updateCountdown() {
    const endDate = new Date();
    endDate.setDate(endDate.getDate() + 7);
    
    const now = new Date();
    const diff = endDate - now;
    
    const days = Math.floor(diff / (1000 * 60 * 60 * 24));
    const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((diff % (1000 * 60)) / 1000);
    
    document.getElementById('days').textContent = String(days).padStart(2, '0');
    document.getElementById('hours').textContent = String(hours).padStart(2, '0');
    document.getElementById('minutes').textContent = String(minutes).padStart(2, '0');
    document.getElementById('seconds').textContent = String(seconds).padStart(2, '0');
}

setInterval(updateCountdown, 1000);
updateCountdown();
</script>

<?php require_once 'includes/footer.php'; ?>

