<?php
/**
 * Frontend Configuration
 * OrderFood Portal
 */

// Session start
session_start();

// Site Configuration
define('SITE_NAME', 'OrderFood Portal');
define('SITE_TAGLINE', 'Delicious Food Delivered Fresh');
define('CURRENCY', '$');
define('API_URL', 'https://restaurantmanager.bloomsoft.net/api');

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'restaurantmanage_orderfood_db');
define('DB_USER', 'restaurantmanage_user');
define('DB_PASS', 'phuddukhata123');

// Get database connection
function getDB() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME,
            DB_USER,
            DB_PASS
        );
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->exec("set names utf8");
        return $pdo;
    } catch(PDOException $e) {
        die("Database connection failed: " . $e->getMessage());
    }
}

// Helper Functions
function formatPrice($price) {
    return CURRENCY . number_format($price, 2);
}

function getSettings() {
    $db = getDB();
    $stmt = $db->query("SELECT setting_key, setting_value FROM settings");
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    return $settings;
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function getUser() {
    if (isLoggedIn()) {
        return [
            'id' => $_SESSION['user_id'],
            'name' => $_SESSION['user_name'],
            'email' => $_SESSION['user_email'],
            'phone' => $_SESSION['user_phone'] ?? '',
            'address' => $_SESSION['user_address'] ?? ''
        ];
    }
    return null;
}

// Cart Functions
function getCart() {
    return $_SESSION['cart'] ?? [];
}

function getCartCount() {
    $cart = getCart();
    $count = 0;
    foreach ($cart as $item) {
        $count += $item['quantity'];
    }
    return $count;
}

function getCartTotal() {
    $cart = getCart();
    $total = 0;
    foreach ($cart as $item) {
        $total += $item['total_price'];
    }
    return $total;
}

// Flash Messages
function setFlash($type, $message) {
    $_SESSION['flash'] = ['type' => $type, 'message' => $message];
}

function getFlash() {
    if (isset($_SESSION['flash'])) {
        $flash = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $flash;
    }
    return null;
}

