<?php
$pageTitle = 'Your Cart - OrderFood Portal';
require_once 'config.php';

$db = getDB();
$cart = getCart();

// Get cart items details
$cartItems = [];
$subtotal = 0;

if (!empty($cart)) {
    foreach ($cart as $key => $item) {
        $stmt = $db->prepare("SELECT m.*, c.name as category_name FROM menu_items m JOIN categories c ON m.category_id = c.id WHERE m.id = ?");
        $stmt->execute([$item['item_id']]);
        $menuItem = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($menuItem) {
            $price = $menuItem['discount_price'] ?? $menuItem['price'];
            $totalPrice = $price * $item['quantity'];
            $subtotal += $totalPrice;
            
            $cartItems[$key] = [
                'item' => $menuItem,
                'quantity' => $item['quantity'],
                'variant_id' => $item['variant_id'] ?? null,
                'total_price' => $totalPrice
            ];
        }
    }
}

$deliveryFee = 100;
$tax = $subtotal * 0.05;
$discount = $_SESSION['discount'] ?? 0;
$total = $subtotal + $deliveryFee + $tax - $discount;

require_once 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1 data-aos="fade-up">Your Cart</h1>
        <nav aria-label="breadcrumb" data-aos="fade-up" data-aos-delay="100">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Cart</li>
            </ol>
        </nav>
    </div>
</section>

<!-- Cart Section -->
<section class="cart-section">
    <div class="container">
        <?php if (count($cartItems) > 0): ?>
            <div class="row">
                <!-- Cart Items -->
                <div class="col-lg-8" data-aos="fade-right">
                    <h4 class="mb-4">Cart Items (<?= getCartCount() ?>)</h4>
                    
                    <?php foreach ($cartItems as $key => $cartItem): 
                        $item = $cartItem['item'];
                        $price = $item['discount_price'] ?? $item['price'];
                    ?>
                        <div class="cart-item fade-in">
                            <div class="image">
                                <img src="<?= $item['image'] ? 'uploads/' . htmlspecialchars($item['image']) : 'https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?w=200&h=200&fit=crop' ?>" alt="<?= htmlspecialchars($item['name']) ?>">
                            </div>
                            <div class="details">
                                <h5><?= htmlspecialchars($item['name']) ?></h5>
                                <p><?= htmlspecialchars($item['category_name']) ?> • <?= formatPrice($price) ?> each</p>
                            </div>
                            <div class="quantity">
                                <button class="qty-btn" data-action="decrease" data-key="<?= $key ?>">
                                    <i class="bi bi-dash"></i>
                                </button>
                                <span><?= $cartItem['quantity'] ?></span>
                                <button class="qty-btn" data-action="increase" data-key="<?= $key ?>">
                                    <i class="bi bi-plus"></i>
                                </button>
                            </div>
                            <div class="price"><?= formatPrice($cartItem['total_price']) ?></div>
                            <button class="remove remove-from-cart" data-key="<?= $key ?>">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    <?php endforeach; ?>
                    
                    <div class="d-flex justify-content-between mt-4">
                        <a href="menu.php" class="btn btn-outline-primary">
                            <i class="bi bi-arrow-left me-2"></i>Continue Shopping
                        </a>
                        <a href="cart-handler.php?action=clear" class="btn btn-outline-danger" onclick="return confirm('Clear all items?')">
                            <i class="bi bi-trash me-2"></i>Clear Cart
                        </a>
                    </div>
                </div>
                
                <!-- Cart Summary -->
                <div class="col-lg-4" data-aos="fade-left">
                    <div class="cart-summary">
                        <h4>Order Summary</h4>
                        
                        <div class="row">
                            <span>Subtotal</span>
                            <span><?= formatPrice($subtotal) ?></span>
                        </div>
                        <div class="row">
                            <span>Delivery Fee</span>
                            <span><?= formatPrice($deliveryFee) ?></span>
                        </div>
                        <div class="row">
                            <span>Tax (5%)</span>
                            <span><?= formatPrice($tax) ?></span>
                        </div>
                        <?php if ($discount > 0): ?>
                        <div class="row text-success">
                            <span>Discount</span>
                            <span>-<?= formatPrice($discount) ?></span>
                        </div>
                        <?php endif; ?>
                        <div class="row total">
                            <span>Total</span>
                            <span><?= formatPrice($total) ?></span>
                        </div>
                        
                        <!-- Coupon -->
                        <form id="couponForm" class="coupon-input">
                            <input type="text" name="coupon" placeholder="Coupon Code" value="<?= htmlspecialchars($_SESSION['coupon_code'] ?? '') ?>">
                            <button type="submit" class="btn btn-outline-primary">Apply</button>
                        </form>
                        
                        <a href="checkout.php" class="btn btn-primary btn-lg w-100">
                            Proceed to Checkout <i class="bi bi-arrow-right ms-2"></i>
                        </a>
                        
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="bi bi-shield-check me-1"></i>
                                Secure checkout with SSL encryption
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="bi bi-bag-x"></i>
                <h3>Your cart is empty</h3>
                <p>Looks like you haven't added anything to your cart yet</p>
                <a href="menu.php" class="btn btn-primary btn-lg">
                    <i class="bi bi-grid me-2"></i>Browse Menu
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>

