<?php
$pageTitle = 'About Us - OrderFood Portal';
require_once 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1 data-aos="fade-up">About Us</h1>
        <nav aria-label="breadcrumb" data-aos="fade-up" data-aos-delay="100">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">About Us</li>
            </ol>
        </nav>
    </div>
</section>

<!-- About Section -->
<section class="py-5">
    <div class="container">
        <div class="row align-items-center mb-5">
            <div class="col-lg-6" data-aos="fade-right">
                <img src="https://images.unsplash.com/photo-1555396273-367ea4eb4db5?w=600&h=400&fit=crop" alt="Our Restaurant" class="img-fluid rounded-4 shadow">
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <span class="text-primary fw-bold text-uppercase">Our Story</span>
                <h2 class="mt-2 mb-4">Bringing Delicious Food to Your Doorstep Since 2020</h2>
                <p class="text-muted mb-4">OrderFood Portal started with a simple mission: to make delicious, quality food accessible to everyone. What began as a small kitchen operation has grown into a beloved food delivery service trusted by thousands of customers.</p>
                <p class="text-muted mb-4">We believe that great food should never be compromised, which is why we use only the freshest ingredients and prepare every dish with love and care. Our team of expert chefs brings years of culinary experience to create meals that delight your taste buds.</p>
                <div class="row g-4">
                    <div class="col-6">
                        <div class="d-flex align-items-center gap-3">
                            <div style="width: 60px; height: 60px; background: var(--primary); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                <i class="bi bi-people-fill text-white fs-4"></i>
                            </div>
                            <div>
                                <h4 class="mb-0">500+</h4>
                                <small class="text-muted">Happy Customers</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="d-flex align-items-center gap-3">
                            <div style="width: 60px; height: 60px; background: var(--primary); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                <i class="bi bi-bag-check-fill text-white fs-4"></i>
                            </div>
                            <div>
                                <h4 class="mb-0">2000+</h4>
                                <small class="text-muted">Orders Delivered</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Values Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span>Our Values</span>
            <h2>Why Choose Us</h2>
        </div>
        
        <div class="row g-4">
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="0">
                <div class="text-center p-4 bg-white rounded-4 shadow-sm h-100">
                    <div class="mb-3" style="font-size: 50px;">🍳</div>
                    <h4>Fresh Ingredients</h4>
                    <p class="text-muted">We source only the freshest, highest-quality ingredients for every dish we prepare.</p>
                </div>
            </div>
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="100">
                <div class="text-center p-4 bg-white rounded-4 shadow-sm h-100">
                    <div class="mb-3" style="font-size: 50px;">👨‍🍳</div>
                    <h4>Expert Chefs</h4>
                    <p class="text-muted">Our team of experienced chefs craft each meal with passion and expertise.</p>
                </div>
            </div>
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="200">
                <div class="text-center p-4 bg-white rounded-4 shadow-sm h-100">
                    <div class="mb-3" style="font-size: 50px;">🚀</div>
                    <h4>Fast Delivery</h4>
                    <p class="text-muted">Hot, fresh food delivered to your door in 30 minutes or less.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Team Section -->
<section class="py-5">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span>Our Team</span>
            <h2>Meet the Experts</h2>
        </div>
        
        <div class="row g-4 justify-content-center">
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="0">
                <div class="text-center">
                    <img src="https://i.pravatar.cc/200?img=11" alt="Chef" class="rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                    <h5>Chef Ahmed</h5>
                    <p class="text-primary">Head Chef</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                <div class="text-center">
                    <img src="https://i.pravatar.cc/200?img=32" alt="Chef" class="rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                    <h5>Sara Khan</h5>
                    <p class="text-primary">Pastry Chef</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                <div class="text-center">
                    <img src="https://i.pravatar.cc/200?img=15" alt="Chef" class="rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                    <h5>Usman Ali</h5>
                    <p class="text-primary">Grill Master</p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>

