<?php
/**
 * Update Order Status
 * PUT /api/orders/update_status.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->order_id) && !empty($data->status)) {
    $validStatuses = ['pending', 'confirmed', 'preparing', 'ready', 'out_for_delivery', 'delivered', 'cancelled'];
    
    if (!in_array($data->status, $validStatuses)) {
        http_response_code(400);
        echo json_encode([
            "success" => false,
            "message" => "Invalid status. Valid statuses are: " . implode(', ', $validStatuses)
        ]);
        exit;
    }
    
    try {
        $query = "UPDATE orders SET order_status = :status";
        
        // If delivered, set delivered_at timestamp
        if ($data->status === 'delivered') {
            $query .= ", delivered_at = NOW()";
        }
        
        // If cancelled or delivered, update payment status if cash
        if ($data->status === 'delivered') {
            $query .= ", payment_status = 'paid'";
        }
        
        $query .= " WHERE id = :order_id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':status', $data->status);
        $stmt->bindParam(':order_id', $data->order_id);
        
        if ($stmt->execute()) {
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                echo json_encode([
                    "success" => true,
                    "message" => "Order status updated to " . $data->status
                ]);
            } else {
                http_response_code(404);
                echo json_encode([
                    "success" => false,
                    "message" => "Order not found"
                ]);
            }
        }
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error updating order: " . $e->getMessage()
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Order ID and status are required"
    ]);
}

