<?php
/**
 * Get Menu Items
 * GET /api/menu/read.php
 * GET /api/menu/read.php?category_id=1
 * GET /api/menu/read.php?featured=1
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    $query = "SELECT 
                m.*, 
                c.name as category_name,
                (SELECT JSON_ARRAYAGG(
                    JSON_OBJECT('id', v.id, 'name', v.name, 'price_addition', v.price_addition, 'is_default', v.is_default)
                ) FROM item_variants v WHERE v.menu_item_id = m.id) as variants
              FROM menu_items m 
              LEFT JOIN categories c ON m.category_id = c.id 
              WHERE m.is_available = 1";
    
    // Filter by category
    if (isset($_GET['category_id'])) {
        $query .= " AND m.category_id = :category_id";
    }
    
    // Filter featured items
    if (isset($_GET['featured'])) {
        $query .= " AND m.is_featured = 1";
    }
    
    // Search
    if (isset($_GET['search'])) {
        $query .= " AND (m.name LIKE :search OR m.description LIKE :search)";
    }
    
    $query .= " ORDER BY m.sort_order ASC, m.id DESC";
    
    $stmt = $db->prepare($query);
    
    if (isset($_GET['category_id'])) {
        $stmt->bindParam(':category_id', $_GET['category_id']);
    }
    
    if (isset($_GET['search'])) {
        $search = "%" . $_GET['search'] . "%";
        $stmt->bindParam(':search', $search);
    }
    
    $stmt->execute();
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Parse variants JSON
    foreach ($items as &$item) {
        $item['variants'] = json_decode($item['variants']) ?? [];
    }
    
    http_response_code(200);
    echo json_encode([
        "success" => true,
        "data" => $items
    ]);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error fetching menu items: " . $e->getMessage()
    ]);
}

