<?php
/**
 * Create Menu Item
 * POST /api/menu/create.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->name) && !empty($data->category_id) && !empty($data->price)) {
    try {
        $db->beginTransaction();
        
        $query = "INSERT INTO menu_items 
                  (category_id, name, description, price, discount_price, image, is_vegetarian, is_spicy, is_featured, preparation_time, calories) 
                  VALUES 
                  (:category_id, :name, :description, :price, :discount_price, :image, :is_vegetarian, :is_spicy, :is_featured, :preparation_time, :calories)";
        
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':category_id', $data->category_id);
        $stmt->bindParam(':name', $data->name);
        $stmt->bindParam(':description', $data->description ?? '');
        $stmt->bindParam(':price', $data->price);
        $stmt->bindParam(':discount_price', $data->discount_price);
        $stmt->bindParam(':image', $data->image ?? '');
        $stmt->bindParam(':is_vegetarian', $data->is_vegetarian ?? false);
        $stmt->bindParam(':is_spicy', $data->is_spicy ?? false);
        $stmt->bindParam(':is_featured', $data->is_featured ?? false);
        $stmt->bindParam(':preparation_time', $data->preparation_time ?? 30);
        $stmt->bindParam(':calories', $data->calories);
        
        $stmt->execute();
        $itemId = $db->lastInsertId();
        
        // Add variants if provided
        if (!empty($data->variants) && is_array($data->variants)) {
            $variantQuery = "INSERT INTO item_variants (menu_item_id, name, price_addition, is_default) VALUES (:menu_item_id, :name, :price_addition, :is_default)";
            $variantStmt = $db->prepare($variantQuery);
            
            foreach ($data->variants as $variant) {
                $variantStmt->bindParam(':menu_item_id', $itemId);
                $variantStmt->bindParam(':name', $variant->name);
                $variantStmt->bindParam(':price_addition', $variant->price_addition ?? 0);
                $variantStmt->bindParam(':is_default', $variant->is_default ?? false);
                $variantStmt->execute();
            }
        }
        
        $db->commit();
        
        http_response_code(201);
        echo json_encode([
            "success" => true,
            "message" => "Menu item created successfully",
            "id" => $itemId
        ]);
    } catch(PDOException $e) {
        $db->rollBack();
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error creating menu item: " . $e->getMessage()
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Name, category_id and price are required"
    ]);
}

