<?php
require_once '../config/cors.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$id = $_GET['id'] ?? 0;

if (empty($id)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Location ID is required'
    ]);
    exit;
}

try {
    // Check if location is used in orders
    $checkQuery = "SELECT COUNT(*) as count FROM orders WHERE location_id = ?";
    $checkStmt = $db->prepare($checkQuery);
    $checkStmt->execute([$id]);
    $result = $checkStmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result['count'] > 0) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Cannot delete location. It is being used in existing orders.'
        ]);
        exit;
    }
    
    $query = "DELETE FROM locations WHERE id = ?";
    $stmt = $db->prepare($query);
    $stmt->execute([$id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Location deleted successfully'
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error deleting location: ' . $e->getMessage()
    ]);
}


