<?php
require_once '../config/cors.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents('php://input'), true);

$name = $data['name'] ?? '';
$address = $data['address'] ?? '';
$city = $data['city'] ?? '';
$state = $data['state'] ?? '';
$zip_code = $data['zip_code'] ?? '';
$country = $data['country'] ?? 'United States';
$phone = $data['phone'] ?? '';
$email = $data['email'] ?? '';
$is_active = isset($data['is_active']) ? (int)$data['is_active'] : 1;

if (empty($name) || empty($address)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Name and address are required'
    ]);
    exit;
}

try {
    $query = "INSERT INTO locations (name, address, city, state, zip_code, country, phone, email, is_active) 
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $db->prepare($query);
    
    $stmt->execute([$name, $address, $city, $state, $zip_code, $country, $phone, $email, $is_active]);
    
    $locationId = $db->lastInsertId();
    
    echo json_encode([
        'success' => true,
        'message' => 'Location created successfully',
        'data' => ['id' => $locationId]
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error creating location: ' . $e->getMessage()
    ]);
}


