<?php
/**
 * Dashboard Statistics
 * GET /api/dashboard/stats.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Total Orders
    $totalOrdersQuery = $db->query("SELECT COUNT(*) as count FROM orders");
    $totalOrders = $totalOrdersQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Total Revenue
    $revenueQuery = $db->query("SELECT COALESCE(SUM(total_amount), 0) as revenue FROM orders WHERE order_status = 'delivered'");
    $totalRevenue = $revenueQuery->fetch(PDO::FETCH_ASSOC)['revenue'];
    
    // Pending Orders
    $pendingQuery = $db->query("SELECT COUNT(*) as count FROM orders WHERE order_status = 'pending'");
    $pendingOrders = $pendingQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Confirmed Orders
    $confirmedQuery = $db->query("SELECT COUNT(*) as count FROM orders WHERE order_status = 'confirmed'");
    $confirmedOrders = $confirmedQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Preparing Orders
    $preparingQuery = $db->query("SELECT COUNT(*) as count FROM orders WHERE order_status = 'preparing'");
    $preparingOrders = $preparingQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Out for Delivery
    $outForDeliveryQuery = $db->query("SELECT COUNT(*) as count FROM orders WHERE order_status = 'out_for_delivery'");
    $outForDeliveryOrders = $outForDeliveryQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Delivered Today
    $deliveredTodayQuery = $db->query("SELECT COUNT(*) as count FROM orders WHERE order_status = 'delivered' AND DATE(delivered_at) = CURDATE()");
    $deliveredToday = $deliveredTodayQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Total Customers
    $customersQuery = $db->query("SELECT COUNT(*) as count FROM users WHERE role = 'customer'");
    $totalCustomers = $customersQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Total Menu Items
    $menuQuery = $db->query("SELECT COUNT(*) as count FROM menu_items WHERE is_available = 1");
    $totalMenuItems = $menuQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Today's Orders
    $todayOrdersQuery = $db->query("SELECT COUNT(*) as count FROM orders WHERE DATE(created_at) = CURDATE()");
    $todayOrders = $todayOrdersQuery->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Today's Revenue
    $todayRevenueQuery = $db->query("SELECT COALESCE(SUM(total_amount), 0) as revenue FROM orders WHERE DATE(created_at) = CURDATE() AND order_status != 'cancelled'");
    $todayRevenue = $todayRevenueQuery->fetch(PDO::FETCH_ASSOC)['revenue'];
    
    http_response_code(200);
    echo json_encode([
        "success" => true,
        "data" => [
            "totalOrders" => (int)$totalOrders,
            "totalRevenue" => (float)$totalRevenue,
            "pendingOrders" => (int)$pendingOrders,
            "confirmedOrders" => (int)$confirmedOrders,
            "preparingOrders" => (int)$preparingOrders,
            "outForDeliveryOrders" => (int)$outForDeliveryOrders,
            "deliveredToday" => (int)$deliveredToday,
            "totalCustomers" => (int)$totalCustomers,
            "totalMenuItems" => (int)$totalMenuItems,
            "todayOrders" => (int)$todayOrders,
            "todayRevenue" => (float)$todayRevenue
        ]
    ]);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error fetching stats: " . $e->getMessage()
    ]);
}

