<?php
/**
 * User Login
 * POST /api/auth/login.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->email) && !empty($data->password)) {
    try {
        $query = "SELECT id, name, email, password, phone, address, role, profile_image, is_active FROM users WHERE email = :email";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':email', $data->email);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$user['is_active']) {
                http_response_code(403);
                echo json_encode([
                    "success" => false,
                    "message" => "Your account has been deactivated"
                ]);
                exit;
            }
            
            if (password_verify($data->password, $user['password'])) {
                // Generate simple token (in production, use JWT)
                $token = bin2hex(random_bytes(32));
                
                // Remove password from response
                unset($user['password']);
                
                http_response_code(200);
                echo json_encode([
                    "success" => true,
                    "message" => "Login successful",
                    "token" => $token,
                    "user" => $user
                ]);
            } else {
                http_response_code(401);
                echo json_encode([
                    "success" => false,
                    "message" => "Invalid password"
                ]);
            }
        } else {
            http_response_code(401);
            echo json_encode([
                "success" => false,
                "message" => "User not found with this email"
            ]);
        }
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error: " . $e->getMessage()
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Email and password are required"
    ]);
}

