<?php
/**
 * Get All Addons
 * GET /api/addons/read.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    $query = "SELECT * FROM addons WHERE is_available = 1 ORDER BY category, name";
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    $addons = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Group by category
    $grouped = [];
    foreach ($addons as $addon) {
        $category = $addon['category'] ?? 'other';
        if (!isset($grouped[$category])) {
            $grouped[$category] = [];
        }
        $grouped[$category][] = $addon;
    }
    
    http_response_code(200);
    echo json_encode([
        "success" => true,
        "data" => $addons,
        "grouped" => $grouped
    ]);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error fetching addons: " . $e->getMessage()
    ]);
}

