<?php
$pageTitle = 'Sign Up - OrderFood Portal';
require_once 'config.php';

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    $errors = [];
    
    if (empty($name)) $errors[] = 'Name is required';
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Valid email is required';
    if (empty($phone)) $errors[] = 'Phone number is required';
    if (strlen($password) < 6) $errors[] = 'Password must be at least 6 characters';
    if ($password !== $confirmPassword) $errors[] = 'Passwords do not match';
    
    if (empty($errors)) {
        $db = getDB();
        
        // Check if email exists
        $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        
        if ($stmt->fetch()) {
            $errors[] = 'Email is already registered';
        } else {
            // Create user
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            
            $stmt = $db->prepare("INSERT INTO users (name, email, password, phone, role) VALUES (?, ?, ?, ?, 'customer')");
            $stmt->execute([$name, $email, $hashedPassword, $phone]);
            
            $userId = $db->lastInsertId();
            
            // Auto login
            $_SESSION['user_id'] = $userId;
            $_SESSION['user_name'] = $name;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_phone'] = $phone;
            $_SESSION['user_role'] = 'customer';
            
            setFlash('success', 'Account created successfully! Welcome, ' . $name . '!');
            header('Location: index.php');
            exit;
        }
    }
    
    foreach ($errors as $error) {
        setFlash('danger', $error);
    }
}

require_once 'includes/header.php';
?>

<!-- Auth Section -->
<section class="auth-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="auth-card">
                    <div class="row g-0">
                        <!-- Image Side -->
                        <div class="col-lg-6 d-none d-lg-block">
                            <div class="image-side">
                                <i class="bi bi-fire" style="font-size: 80px; margin-bottom: 20px;"></i>
                                <h2>Join Us Today!</h2>
                                <p>Create an account to enjoy fast ordering, track your orders, and get exclusive offers.</p>
                                <img src="https://images.unsplash.com/photo-1567620905732-2d1ec7ab7445?w=400&h=300&fit=crop" alt="Food" class="img-fluid rounded-4 mt-4">
                            </div>
                        </div>
                        
                        <!-- Form Side -->
                        <div class="col-lg-6">
                            <div class="form-side position-relative">
                                <!-- Close Button -->
                                <a href="index.php" class="btn-close-auth" title="Close">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                                
                                <div class="text-center mb-4">
                                    <h3>Create Your Account</h3>
                                    <p class="text-muted">Fill in the form to get started</p>
                                </div>
                                
                                <form method="POST" action="">
                                    <div class="form-floating mb-3">
                                        <input type="text" class="form-control" id="name" name="name" placeholder="Full Name" value="<?= htmlspecialchars($_POST['name'] ?? '') ?>" required>
                                        <label for="name"><i class="bi bi-person me-2"></i>Full Name</label>
                                    </div>
                                    
                                    <div class="form-floating mb-3">
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
                                        <label for="email"><i class="bi bi-envelope me-2"></i>Email Address</label>
                                    </div>
                                    
                                    <div class="form-floating mb-3">
                                        <input type="tel" class="form-control" id="phone" name="phone" placeholder="Phone" value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>" required>
                                        <label for="phone"><i class="bi bi-phone me-2"></i>Phone Number</label>
                                    </div>
                                    
                                    <div class="form-floating mb-3">
                                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required minlength="6">
                                        <label for="password"><i class="bi bi-lock me-2"></i>Password</label>
                                    </div>
                                    
                                    <div class="form-floating mb-3">
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirm Password" required>
                                        <label for="confirm_password"><i class="bi bi-lock-fill me-2"></i>Confirm Password</label>
                                    </div>
                                    
                                    <div class="form-check mb-4">
                                        <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                                        <label class="form-check-label" for="terms">
                                            I agree to the <a href="#" class="text-primary">Terms & Conditions</a>
                                        </label>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                                        <i class="bi bi-person-plus me-2"></i>Create Account
                                    </button>
                                    
                                    <div class="text-center">
                                        <span class="text-muted">Already have an account?</span>
                                        <a href="login.php" class="text-primary fw-bold smooth-link">Login</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>

