<?php
$pageTitle = 'Order Placed - OrderFood Portal';
require_once 'config.php';

// Check if order was just placed
if (!isset($_SESSION['last_order'])) {
    header('Location: index.php');
    exit;
}

$order = $_SESSION['last_order'];
unset($_SESSION['last_order']);

require_once 'includes/header.php';
?>

<!-- Success Section -->
<section class="py-5" style="margin-top: 100px;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center" data-aos="zoom-in">
                <div class="success-animation mb-4">
                    <div style="width: 120px; height: 120px; background: linear-gradient(135deg, #28a745, #20c997); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                        <i class="bi bi-check-lg text-white" style="font-size: 60px;"></i>
                    </div>
                </div>
                
                <h1 class="mb-3">Order Placed Successfully!</h1>
                <p class="text-muted mb-4">Thank you for your order. We're preparing your delicious food right now!</p>
                
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row text-start">
                            <div class="col-6 mb-3">
                                <small class="text-muted">Order Number</small>
                                <h5 class="mb-0"><?= htmlspecialchars($order['order_number']) ?></h5>
                            </div>
                            <div class="col-6 mb-3">
                                <small class="text-muted">Total Amount</small>
                                <h5 class="mb-0 text-primary"><?= formatPrice($order['total']) ?></h5>
                            </div>
                            <div class="col-12">
                                <small class="text-muted">Estimated Delivery</small>
                                <h5 class="mb-0">
                                    <i class="bi bi-clock me-1"></i>
                                    <?= date('h:i A', strtotime($order['estimated_delivery'])) ?>
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Order Tracking -->
                <div class="order-tracking mb-4">
                    <h5 class="mb-4">Order Status</h5>
                    <div class="tracking-steps">
                        <div class="tracking-step current">
                            <div class="icon"><i class="bi bi-check"></i></div>
                            <p>Order Placed</p>
                        </div>
                        <div class="tracking-step">
                            <div class="icon"><i class="bi bi-hourglass-split"></i></div>
                            <p>Confirmed</p>
                        </div>
                        <div class="tracking-step">
                            <div class="icon"><i class="bi bi-fire"></i></div>
                            <p>Preparing</p>
                        </div>
                        <div class="tracking-step">
                            <div class="icon"><i class="bi bi-truck"></i></div>
                            <p>On the Way</p>
                        </div>
                        <div class="tracking-step">
                            <div class="icon"><i class="bi bi-house-check"></i></div>
                            <p>Delivered</p>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex gap-3 justify-content-center flex-wrap">
                    <a href="track-order.php?order=<?= urlencode($order['order_number']) ?>" class="btn btn-primary">
                        <i class="bi bi-geo-alt me-2"></i>Track Order
                    </a>
                    <a href="menu.php" class="btn btn-outline-primary">
                        <i class="bi bi-grid me-2"></i>Order More
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.success-animation {
    animation: scaleIn 0.5s ease;
}

@keyframes scaleIn {
    from { transform: scale(0); }
    to { transform: scale(1); }
}
</style>

<?php require_once 'includes/footer.php'; ?>

