<?php
$pageTitle = 'Contact Us - OrderFood Portal';
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');
    
    if (!empty($name) && !empty($email) && !empty($message)) {
        $db = getDB();
        $stmt = $db->prepare("INSERT INTO contact_messages (name, email, phone, subject, message) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$name, $email, $phone, $subject, $message]);
        
        setFlash('success', 'Thank you for your message! We will get back to you soon.');
    } else {
        setFlash('danger', 'Please fill in all required fields.');
    }
}

require_once 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1 data-aos="fade-up">Contact Us</h1>
        <nav aria-label="breadcrumb" data-aos="fade-up" data-aos-delay="100">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Contact</li>
            </ol>
        </nav>
    </div>
</section>

<!-- Contact Section -->
<section class="py-5">
    <div class="container">
        <div class="row g-5">
            <!-- Contact Info -->
            <div class="col-lg-5" data-aos="fade-right">
                <span class="text-primary fw-bold text-uppercase">Get in Touch</span>
                <h2 class="mt-2 mb-4">We'd Love to Hear From You</h2>
                <p class="text-muted mb-5">Have a question, feedback, or just want to say hello? Drop us a message and we'll get back to you as soon as possible.</p>
                
                <div class="d-flex gap-4 mb-4">
                    <div style="width: 60px; height: 60px; background: linear-gradient(135deg, var(--primary-light), var(--primary)); border-radius: 15px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <i class="bi bi-geo-alt-fill text-white fs-4"></i>
                    </div>
                    <div>
                        <h5 class="mb-1">Our Location</h5>
                        <p class="text-muted mb-0">123 Food Street, Gulberg III<br>Lahore, Pakistan</p>
                    </div>
                </div>
                
                <div class="d-flex gap-4 mb-4">
                    <div style="width: 60px; height: 60px; background: linear-gradient(135deg, var(--primary-light), var(--primary)); border-radius: 15px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <i class="bi bi-telephone-fill text-white fs-4"></i>
                    </div>
                    <div>
                        <h5 class="mb-1">Phone Number</h5>
                        <p class="text-muted mb-0">+92 300 1234567<br>+92 42 35761234</p>
                    </div>
                </div>
                
                <div class="d-flex gap-4 mb-4">
                    <div style="width: 60px; height: 60px; background: linear-gradient(135deg, var(--primary-light), var(--primary)); border-radius: 15px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <i class="bi bi-envelope-fill text-white fs-4"></i>
                    </div>
                    <div>
                        <h5 class="mb-1">Email Address</h5>
                        <p class="text-muted mb-0">info@orderfood.com<br>support@orderfood.com</p>
                    </div>
                </div>
                
                <div class="d-flex gap-4">
                    <div style="width: 60px; height: 60px; background: linear-gradient(135deg, var(--primary-light), var(--primary)); border-radius: 15px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <i class="bi bi-clock-fill text-white fs-4"></i>
                    </div>
                    <div>
                        <h5 class="mb-1">Working Hours</h5>
                        <p class="text-muted mb-0">Mon - Sun: 10:00 AM - 11:00 PM<br>Open 7 days a week</p>
                    </div>
                </div>
            </div>
            
            <!-- Contact Form -->
            <div class="col-lg-7" data-aos="fade-left">
                <div class="bg-white p-5 rounded-4 shadow-sm">
                    <h4 class="mb-4">Send us a Message</h4>
                    
                    <form method="POST" action="">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="Your Name" required>
                                    <label for="name">Your Name *</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
                                    <label for="email">Email Address *</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="tel" class="form-control" id="phone" name="phone" placeholder="Phone">
                                    <label for="phone">Phone Number</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="subject" name="subject" placeholder="Subject">
                                    <label for="subject">Subject</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-floating mb-4">
                            <textarea class="form-control" id="message" name="message" placeholder="Message" style="height: 150px" required></textarea>
                            <label for="message">Your Message *</label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="bi bi-send me-2"></i>Send Message
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Map Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="rounded-4 overflow-hidden shadow" data-aos="fade-up">
            <iframe 
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3401.5456799999!2d74.3436!3d31.5204!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzHCsDMxJzEzLjQiTiA3NMKwMjAnMzYuOSJF!5e0!3m2!1sen!2s!4v1234567890"
                width="100%" 
                height="400" 
                style="border:0;" 
                allowfullscreen="" 
                loading="lazy">
            </iframe>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>

