<?php
/**
 * Setup Locations Table and Add to Orders
 * Run this file once to set up locations feature
 */

// Database connection
$host = 'localhost';
$dbname = 'orderfood_db';
$username = 'root';
$password = '';

try {
    $db = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

$db = getDB();

try {
    // Create locations table
    $db->exec("CREATE TABLE IF NOT EXISTS locations (
        id INT PRIMARY KEY AUTO_INCREMENT,
        name VARCHAR(100) NOT NULL,
        address TEXT NOT NULL,
        city VARCHAR(100),
        state VARCHAR(100),
        zip_code VARCHAR(20),
        country VARCHAR(100) DEFAULT 'United States',
        phone VARCHAR(20),
        email VARCHAR(100),
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    
    echo "✓ Locations table created\n";
    
    // Check if location_id column exists
    $columns = $db->query("SHOW COLUMNS FROM orders LIKE 'location_id'")->fetchAll();
    if (empty($columns)) {
        // Add location_id to orders table
        $db->exec("ALTER TABLE orders ADD COLUMN location_id INT NULL AFTER order_type");
        echo "✓ location_id column added to orders table\n";
        
        // Add foreign key if not exists
        try {
            $db->exec("ALTER TABLE orders ADD FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE SET NULL");
            echo "✓ Foreign key added\n";
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate') === false) {
                echo "⚠ Foreign key might already exist: " . $e->getMessage() . "\n";
            }
        }
    } else {
        echo "✓ location_id column already exists\n";
    }
    
    // Insert default locations
    $check = $db->query("SELECT COUNT(*) as count FROM locations")->fetch(PDO::FETCH_ASSOC);
    if ($check['count'] == 0) {
        $db->exec("INSERT INTO locations (name, address, city, state, zip_code, country, phone, email) VALUES
            ('Wilmington Main Branch', '123 Main Street', 'Wilmington', 'Delaware', '19801', 'United States', '+1 (914) 520 5495', 'info@orderfood.com'),
            ('Newark Branch', '456 Commerce Drive', 'Newark', 'Delaware', '19711', 'United States', '+1 (302) 555-1234', 'newark@orderfood.com'),
            ('Dover Branch', '789 Market Street', 'Dover', 'Delaware', '19901', 'United States', '+1 (302) 555-5678', 'dover@orderfood.com')");
        echo "✓ Default locations inserted\n";
    } else {
        echo "✓ Locations already exist\n";
    }
    
    echo "\n✅ Setup complete! Location selection feature is ready.\n";
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

