<?php
/**
 * Get Settings
 * GET /api/settings/read.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    $query = "SELECT setting_key, setting_value, setting_type FROM settings";
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $value = $row['setting_value'];
        
        // Convert to appropriate type
        if ($row['setting_type'] === 'number') {
            $value = (float)$value;
        } elseif ($row['setting_type'] === 'boolean') {
            $value = filter_var($value, FILTER_VALIDATE_BOOLEAN);
        }
        
        $settings[$row['setting_key']] = $value;
    }
    
    http_response_code(200);
    echo json_encode([
        "success" => true,
        "data" => $settings
    ]);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error fetching settings: " . $e->getMessage()
    ]);
}

