<?php
/**
 * Get Menu Items
 * GET /api/menu/read.php
 * GET /api/menu/read.php?category_id=1
 * GET /api/menu/read.php?featured=1
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    $query = "SELECT 
                m.*, 
                c.name as category_name
              FROM menu_items m 
              LEFT JOIN categories c ON m.category_id = c.id 
              WHERE 1=1";
    
    // Filter by availability (optional - default shows all)
    if (isset($_GET['is_available']) && $_GET['is_available'] !== '') {
        $query .= " AND m.is_available = :is_available";
    }
    
    // Filter by category
    if (isset($_GET['category_id']) && $_GET['category_id'] !== '') {
        $query .= " AND m.category_id = :category_id";
    }
    
    // Filter featured items
    if (isset($_GET['featured'])) {
        $query .= " AND m.is_featured = 1";
    }
    
    // Search
    if (isset($_GET['search']) && $_GET['search'] !== '') {
        $query .= " AND (m.name LIKE :search OR m.description LIKE :search)";
    }
    
    $query .= " ORDER BY m.sort_order ASC, m.id DESC";
    
    $stmt = $db->prepare($query);
    
    if (isset($_GET['is_available']) && $_GET['is_available'] !== '') {
        $is_available = (int)$_GET['is_available'];
        $stmt->bindParam(':is_available', $is_available, PDO::PARAM_INT);
    }
    
    if (isset($_GET['category_id']) && $_GET['category_id'] !== '') {
        $category_id = (int)$_GET['category_id'];
        $stmt->bindParam(':category_id', $category_id, PDO::PARAM_INT);
    }
    
    if (isset($_GET['search']) && $_GET['search'] !== '') {
        $search = "%" . $_GET['search'] . "%";
        $stmt->bindParam(':search', $search);
    }
    
    $stmt->execute();
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get variants for each item separately (more compatible with older MySQL)
    foreach ($items as &$item) {
        $variantQuery = "SELECT id, name, price_addition, is_default FROM item_variants WHERE menu_item_id = ?";
        $variantStmt = $db->prepare($variantQuery);
        $variantStmt->execute([$item['id']]);
        $item['variants'] = $variantStmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    http_response_code(200);
    echo json_encode([
        "success" => true,
        "data" => $items
    ]);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error fetching menu items: " . $e->getMessage()
    ]);
}

