<?php
/**
 * CORS Configuration
 * Allow Angular admin to access API
 */

// Allow requests from frontend and admin
$allowed_origins = [
    'http://restaurantmanager.bloomsoft.net',
    'https://restaurantmanager.bloomsoft.net',
    'http://localhost:4200',  // Local admin development
    'http://localhost'  // Local frontend development
];

$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if (in_array($origin, $allowed_origins)) {
    header("Access-Control-Allow-Origin: $origin");
} else {
    header("Access-Control-Allow-Origin: *");  // Fallback for other origins
}
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

