<?php
/**
 * Create Category
 * POST /api/categories/create.php
 */

include_once '../config/cors.php';
include_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->name)) {
    try {
        $query = "INSERT INTO categories (name, description, image, sort_order) VALUES (:name, :description, :image, :sort_order)";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(':name', $data->name);
        $stmt->bindParam(':description', $data->description ?? '');
        $stmt->bindParam(':image', $data->image ?? '');
        $stmt->bindParam(':sort_order', $data->sort_order ?? 0);
        
        if ($stmt->execute()) {
            http_response_code(201);
            echo json_encode([
                "success" => true,
                "message" => "Category created successfully",
                "id" => $db->lastInsertId()
            ]);
        }
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error creating category: " . $e->getMessage()
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Category name is required"
    ]);
}

