<?php
require_once 'config.php';
requireAdminLogin();

$pageTitle = 'Settings';
require_once 'includes/header.php';
?>

<div class="page-title">
    <div>
        <h1>Settings</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item active">Settings</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">General Settings</h5>
            </div>
            <div class="card-body">
                <form id="settingsForm">
                    <div class="mb-3">
                        <label class="form-label">Restaurant Name</label>
                        <input type="text" class="form-control" id="restaurantName">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" id="restaurantEmail">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone</label>
                        <input type="text" class="form-control" id="restaurantPhone">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Address</label>
                        <textarea class="form-control" rows="3" id="restaurantAddress"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Currency</label>
                        <input type="text" class="form-control" id="currency" value="$">
                    </div>
                    <button type="button" class="btn btn-primary" onclick="saveSettings()">
                        <i class="bi bi-save me-2"></i>Save Settings
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    loadSettings();
});

function loadSettings() {
    AdminAPI.get('/settings/read.php')
        .done(function(response) {
            if (response.success) {
                const settings = response.data;
                // Populate form with settings
                if (settings.restaurant_name) $('#restaurantName').val(settings.restaurant_name);
                if (settings.email) $('#restaurantEmail').val(settings.email);
                if (settings.phone) $('#restaurantPhone').val(settings.phone);
                if (settings.address) $('#restaurantAddress').val(settings.address);
                if (settings.currency) $('#currency').val(settings.currency);
            }
        })
        .fail(function(xhr) {
            handleApiError(xhr);
        });
}

function saveSettings() {
    const data = {
        restaurant_name: $('#restaurantName').val(),
        email: $('#restaurantEmail').val(),
        phone: $('#restaurantPhone').val(),
        address: $('#restaurantAddress').val(),
        currency: $('#currency').val()
    };
    
    const button = event.target;
    setLoading(button, true);
    
    AdminAPI.put('/settings/update.php', data)
        .done(function(response) {
            if (response.success) {
                showNotification('success', 'Settings saved successfully');
            } else {
                showNotification('error', response.message || 'Failed to save settings');
            }
            setLoading(button, false);
        })
        .fail(function(xhr) {
            handleApiError(xhr);
            setLoading(button, false);
        });
}
</script>

<?php require_once 'includes/footer.php'; ?>

