<?php
require_once 'config.php';

$db = getDB();

// Reset admin password to 'admin123'
$email = 'admin@orderfood.com';
$newPassword = 'admin123';
$hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

try {
    $stmt = $db->prepare("UPDATE users SET password = ? WHERE email = ? AND role = 'admin'");
    $stmt->execute([$hashedPassword, $email]);
    
    if ($stmt->rowCount() > 0) {
        echo "<h2 style='color: green;'>✅ Admin password reset successfully!</h2>";
        echo "<h3>Login Credentials:</h3>";
        echo "<p><strong>Email:</strong> $email</p>";
        echo "<p><strong>Password:</strong> $newPassword</p>";
        echo "<p><a href='login.php' style='display: inline-block; padding: 10px 20px; background: #C41E3A; color: white; text-decoration: none; border-radius: 5px; margin-top: 20px;'>Go to Login</a></p>";
    } else {
        echo "<h2 style='color: red;'>❌ Admin user not found!</h2>";
        echo "<p><a href='create-admin.php'>Create Admin User</a></p>";
    }
} catch(PDOException $e) {
    echo "<h2 style='color: red;'>❌ Error: " . $e->getMessage() . "</h2>";
}
?>

