<?php
if (!isset($pageTitle)) {
    $pageTitle = 'Admin Dashboard';
}
$admin = getAdmin();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?> - OrderFood Admin</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    
    <!-- Custom CSS -->
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-brand">
                <i class="bi bi-fire text-primary"></i>
                <span>OrderFood</span>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-header">Main</div>
                <a href="dashboard.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>">
                    <i class="bi bi-grid-1x2-fill"></i>
                    <span>Dashboard</span>
                </a>
                <a href="orders.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'orders.php' ? 'active' : '' ?>">
                    <i class="bi bi-receipt"></i>
                    <span>Orders</span>
                </a>
                
                <div class="nav-header">Menu Management</div>
                <a href="menu.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'menu.php' ? 'active' : '' ?>">
                    <i class="bi bi-egg-fried"></i>
                    <span>Menu Items</span>
                </a>
                <a href="categories.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'active' : '' ?>">
                    <i class="bi bi-tags-fill"></i>
                    <span>Categories</span>
                </a>
                <a href="locations.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'locations.php' ? 'active' : '' ?>">
                    <i class="bi bi-geo-alt-fill"></i>
                    <span>Branch Locations</span>
                </a>
                
                <div class="nav-header">Users</div>
                <a href="customers.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'customers.php' ? 'active' : '' ?>">
                    <i class="bi bi-people-fill"></i>
                    <span>Customers</span>
                </a>
                
                <div class="nav-header">System</div>
                <a href="settings.php" class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : '' ?>">
                    <i class="bi bi-gear-fill"></i>
                    <span>Settings</span>
                </a>
            </nav>
        </aside>
        
        <!-- Main Content -->
        <div class="main-content" id="mainContent">
            <!-- Header -->
            <header class="admin-header">
                <div class="header-left">
                    <button class="btn btn-link toggle-sidebar" id="toggleSidebar">
                        <i class="bi bi-list"></i>
                    </button>
                    <div class="search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" placeholder="Search...">
                    </div>
                </div>
                
                <div class="header-right">
                    <button class="btn btn-link notification-btn position-relative">
                        <i class="bi bi-bell-fill"></i>
                        <span class="badge bg-danger position-absolute top-0 start-100 translate-middle">5</span>
                    </button>
                    <div class="dropdown">
                        <button class="btn btn-link dropdown-toggle d-flex align-items-center gap-2" type="button" data-bs-toggle="dropdown">
                            <img src="https://i.pravatar.cc/100?img=11" alt="Admin" class="rounded-circle" style="width: 35px; height: 35px;">
                            <div class="d-none d-md-block text-start">
                                <div class="fw-bold"><?= htmlspecialchars($admin['name'] ?? 'Admin') ?></div>
                                <small class="text-muted">Administrator</small>
                            </div>
                            <i class="bi bi-chevron-down"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person me-2"></i>Profile</a></li>
                            <li><a class="dropdown-item" href="settings.php"><i class="bi bi-gear me-2"></i>Settings</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
                        </ul>
                    </div>
                </div>
            </header>
            
            <!-- Page Content -->
            <div class="page-content">

