<?php
require_once 'config.php';
requireAdminLogin();

$pageTitle = 'Dashboard';
require_once 'includes/header.php';

// Get dashboard stats
$db = getDB();

// Total Orders
$totalOrders = $db->query("SELECT COUNT(*) FROM orders")->fetchColumn();

// Total Revenue
$totalRevenue = $db->query("SELECT COALESCE(SUM(total_amount), 0) FROM orders WHERE order_status = 'delivered'")->fetchColumn();

// Pending Orders
$pendingOrders = $db->query("SELECT COUNT(*) FROM orders WHERE order_status = 'pending'")->fetchColumn();

// Total Customers
$totalCustomers = $db->query("SELECT COUNT(*) FROM users WHERE role = 'customer'")->fetchColumn();

// Recent Orders
$recentOrders = $db->query("
    SELECT o.*, 
           COUNT(oi.id) as item_count
    FROM orders o
    LEFT JOIN order_items oi ON o.id = oi.order_id
    GROUP BY o.id
    ORDER BY o.created_at DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// Top Items
$topItems = $db->query("
    SELECT m.name, m.price, COUNT(oi.id) as orders_count
    FROM menu_items m
    INNER JOIN order_items oi ON m.id = oi.menu_item_id
    GROUP BY m.id
    ORDER BY orders_count DESC
    LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="page-title">
    <div>
        <h1>Dashboard</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">Dashboard</li>
            </ol>
        </nav>
    </div>
    <button class="btn btn-primary" onclick="downloadReport()">
        <i class="bi bi-download me-2"></i>Download Report
    </button>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-xl-3 col-md-6 fade-in">
        <div class="stat-card">
            <div class="stat-icon primary">
                <i class="bi bi-receipt"></i>
            </div>
            <div class="stat-content">
                <p>Total Orders</p>
                <h2><?= number_format($totalOrders) ?></h2>
                <span class="change positive"><i class="bi bi-arrow-up"></i> 12% from last month</span>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 fade-in">
        <div class="stat-card">
            <div class="stat-icon success">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="stat-content">
                <p>Total Revenue</p>
                <h2><?= formatPrice($totalRevenue) ?></h2>
                <span class="change positive"><i class="bi bi-arrow-up"></i> 8% from last month</span>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 fade-in">
        <div class="stat-card">
            <div class="stat-icon warning">
                <i class="bi bi-clock-history"></i>
            </div>
            <div class="stat-content">
                <p>Pending Orders</p>
                <h2><?= number_format($pendingOrders) ?></h2>
                <span class="change negative"><i class="bi bi-arrow-down"></i> Needs attention</span>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 fade-in">
        <div class="stat-card">
            <div class="stat-icon info">
                <i class="bi bi-people"></i>
            </div>
            <div class="stat-content">
                <p>Total Customers</p>
                <h2><?= number_format($totalCustomers) ?></h2>
                <span class="change positive"><i class="bi bi-arrow-up"></i> Growing</span>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Recent Orders -->
    <div class="col-lg-8 fade-in">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Orders</h5>
                <a href="orders.php" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Customer</th>
                                <th>Items</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($recentOrders) > 0): ?>
                                <?php foreach ($recentOrders as $order): ?>
                                    <tr>
                                        <td><strong><?= htmlspecialchars($order['order_number']) ?></strong></td>
                                        <td><?= htmlspecialchars($order['customer_name']) ?></td>
                                        <td><?= $order['item_count'] ?> items</td>
                                        <td><?= formatPrice($order['total_amount']) ?></td>
                                        <td>
                                            <span class="status-badge <?= strtolower(str_replace(' ', '_', $order['order_status'])) ?>">
                                                <?= ucfirst(str_replace('_', ' ', $order['order_status'])) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <a href="orders.php?view=<?= $order['id'] ?>" class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4 text-muted">No recent orders</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Quick Stats -->
    <div class="col-lg-4 fade-in">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Top Selling Items</h5>
            </div>
            <div class="card-body">
                <?php if (count($topItems) > 0): ?>
                    <?php foreach ($topItems as $index => $item): ?>
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px;">
                                <?= $index + 1 ?>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0"><?= htmlspecialchars($item['name']) ?></h6>
                                <small class="text-muted"><?= $item['orders_count'] ?> orders</small>
                            </div>
                            <span class="text-primary fw-bold"><?= formatPrice($item['price']) ?></span>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-center text-muted py-3">No data available</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function downloadReport() {
    // Generate CSV report
    window.location.href = 'reports.php?type=orders';
}
</script>

<?php require_once 'includes/footer.php'; ?>

