<?php
require_once 'config.php';
requireAdminLogin();

$pageTitle = 'Customers';
require_once 'includes/header.php';
?>

<div class="page-title">
    <div>
        <h1>Customers</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item active">Customers</li>
            </ol>
        </nav>
    </div>
</div>

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Address</th>
                        <th>Status</th>
                        <th>Registered</th>
                    </tr>
                </thead>
                <tbody id="customersTableBody">
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <div class="loading"></div> Loading customers...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    loadCustomers();
});

function loadCustomers() {
    AdminAPI.get('/users/read.php')
        .done(function(response) {
            if (response.success) {
                displayCustomers(response.data.filter(u => u.role === 'customer'));
            }
        })
        .fail(function(xhr) {
            handleApiError(xhr);
        });
}

function displayCustomers(customers) {
    const tbody = $('#customersTableBody');
    tbody.empty();
    
    if (customers.length === 0) {
        tbody.html('<tr><td colspan="7" class="text-center py-4 text-muted">No customers found</td></tr>');
        return;
    }
    
    customers.forEach(function(customer) {
        const row = $(`
            <tr>
                <td>${customer.id}</td>
                <td><strong>${customer.name}</strong></td>
                <td>${customer.email}</td>
                <td>${customer.phone || '-'}</td>
                <td>${customer.address || '-'}</td>
                <td>
                    <span class="badge ${customer.is_active ? 'bg-success' : 'bg-danger'}">
                        ${customer.is_active ? 'Active' : 'Inactive'}
                    </span>
                </td>
                <td>${formatDate(customer.created_at || customer.registered_at)}</td>
            </tr>
        `);
        tbody.append(row);
    });
}
</script>

<?php require_once 'includes/footer.php'; ?>

