<?php
/**
 * Create Admin User Helper Script
 * Run this once to create an admin user
 */

require_once 'config.php';

$db = getDB();

// Check if admin already exists
$stmt = $db->query("SELECT COUNT(*) FROM users WHERE role = 'admin'");
$adminCount = $stmt->fetchColumn();

if ($adminCount > 0) {
    echo "<h2>Admin user already exists!</h2>";
    echo "<p>You can login with existing admin credentials.</p>";
    echo "<p><a href='login.php'>Go to Login</a></p>";
    exit;
}

// Create admin user
$name = 'Admin';
$email = 'admin@orderfood.com';
$password = 'admin123'; // Change this after first login
$hashedPassword = password_hash($password, PASSWORD_DEFAULT);
$phone = '03001234567';
$role = 'admin';

try {
    $stmt = $db->prepare("INSERT INTO users (name, email, password, phone, role, is_active) VALUES (?, ?, ?, ?, ?, 1)");
    $stmt->execute([$name, $email, $hashedPassword, $phone, $role]);
    
    echo "<h2 style='color: green;'>✅ Admin user created successfully!</h2>";
    echo "<h3>Login Credentials:</h3>";
    echo "<p><strong>Email:</strong> $email</p>";
    echo "<p><strong>Password:</strong> $password</p>";
    echo "<p style='color: red;'><strong>⚠️ Please change the password after first login!</strong></p>";
    echo "<p><a href='login.php' style='display: inline-block; padding: 10px 20px; background: #C41E3A; color: white; text-decoration: none; border-radius: 5px;'>Go to Login</a></p>";
} catch(PDOException $e) {
    echo "<h2 style='color: red;'>❌ Error creating admin user:</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

