# OrderFood Admin Panel - Simple Version

## 🎯 Overview
This is a **simple HTML/CSS/jQuery/Bootstrap** admin panel that replaces the Angular version.

## 📋 Technology Stack
- **Frontend:** HTML5, CSS3, Bootstrap 5.3.2, jQuery 3.7.1
- **Backend:** PHP 7.4+
- **Database:** MySQL
- **No Angular/TypeScript** - Pure vanilla JavaScript with jQuery

## 📁 File Structure
```
admin_new/
├── config.php              # Database & session config
├── login.php               # Admin login page
├── logout.php              # Logout handler
├── dashboard.php           # Dashboard with stats
├── menu.php                # Menu items management
├── orders.php              # Orders management
├── categories.php          # Categories management
├── locations.php           # Branch locations management
├── customers.php           # Customers list
├── settings.php            # System settings
├── includes/
│   ├── header.php         # Common header
│   └── footer.php         # Common footer
└── assets/
    ├── css/
    │   └── admin.css      # Custom admin styles
    └── js/
        └── admin.js       # jQuery API helpers & utilities
```

## 🚀 Installation

### Step 1: Backup Old Admin
```bash
# Rename old Angular admin (backup)
mv admin admin_old
```

### Step 2: Install New Admin
```bash
# Rename new admin
mv admin_new admin
```

### Step 3: Configure
Edit `admin/config.php` and update database credentials if needed:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'orderfood_db');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### Step 4: Access
Open browser: `http://localhost/orderfood/admin/login.php`

## 🔐 Login Credentials
Use an admin user from your database. Make sure the user has `role = 'admin'` in the `users` table.

## ✨ Features
- ✅ Dashboard with statistics
- ✅ Menu items management (CRUD)
- ✅ Orders management with status updates
- ✅ Categories management
- ✅ Branch locations management
- ✅ Customers list
- ✅ Settings management
- ✅ Responsive design
- ✅ jQuery AJAX for API calls
- ✅ Bootstrap modals for forms
- ✅ Real-time notifications

## 🔧 API Integration
All pages use jQuery AJAX to call the existing PHP API endpoints:
- `GET /api/menu/read.php`
- `POST /api/menu/create.php`
- `PUT /api/orders/update_status.php`
- etc.

## 📝 Notes
- No build process required (unlike Angular)
- No Node.js/npm needed
- Works directly with PHP server
- Simple and lightweight
- Easy to customize

## 🎨 Customization
- Edit `assets/css/admin.css` for styling
- Edit `assets/js/admin.js` for JavaScript functions
- All pages use Bootstrap 5.3.2 components

---

**Created:** December 2025
**Version:** 1.0.0

