# 📊 OrderFood Portal - Technology Stack

## 🎯 Overview
Aapka product **3 main parts** mein divide hai:
1. **Frontend (Customer Side)** - Simple HTML/CSS/Bootstrap
2. **Admin Panel** - Angular 17
3. **Backend API** - PHP with MySQL

---

## 🖥️ **FRONTEND (Customer Side)**
**Location:** `frontend/` folder

### Technologies Used:
- ✅ **PHP** (Server-side logic)
- ✅ **HTML5** (Structure)
- ✅ **CSS3** (Custom styling)
- ✅ **Bootstrap 5.3.2** (CSS Framework)
- ✅ **Bootstrap Icons 1.11.1** (Icons)
- ✅ **Vanilla JavaScript** (No frameworks - pure JS)
- ✅ **Google Fonts** (Playfair Display, Poppins)

### Files Structure:
```
frontend/
├── index.php          (Homepage)
├── menu.php           (Menu listing)
├── cart.php           (Shopping cart)
├── checkout.php       (Order checkout)
├── orders.php         (User orders)
├── profile.php        (User profile)
├── login.php          (User login)
├── register.php       (User registration)
├── config.php         (Database config & helper functions)
├── assets/
│   ├── css/style.css  (Custom CSS)
│   └── js/main.js     (Vanilla JavaScript)
└── includes/
    ├── header.php     (Header template)
    └── footer.php     (Footer template)
```

### Key Features:
- Server-side rendering (PHP)
- Session-based authentication
- Shopping cart functionality
- Order management
- Responsive design (Bootstrap)

---

## ⚙️ **ADMIN PANEL**
**Location:** `admin/` folder

### Technologies Used:
- ✅ **Angular 17** (Frontend Framework)
- ✅ **TypeScript** (Programming Language)
- ✅ **Bootstrap 5.3.2** (CSS Framework)
- ✅ **Bootstrap Icons** (Icons)
- ✅ **Chart.js** (Charts for dashboard)
- ✅ **RxJS** (Reactive programming)
- ✅ **Angular Router** (Routing)

### Dependencies:
```json
{
  "@angular/core": "^17.0.0",
  "@angular/router": "^17.0.0",
  "@angular/forms": "^17.0.0",
  "bootstrap": "^5.3.2",
  "chart.js": "^4.4.1",
  "ng2-charts": "^5.0.0"
}
```

### Features:
- Dashboard with statistics
- Menu management (CRUD)
- Order management
- Category management
- Customer management
- Settings management
- Location/Branch management

---

## 🔧 **BACKEND API**
**Location:** `api/` folder

### Technologies Used:
- ✅ **PHP 7.4+** (Server-side language)
- ✅ **PDO** (PHP Data Objects - Database abstraction)
- ✅ **MySQL** (Database)
- ✅ **RESTful API** (API architecture)
- ✅ **CORS** (Cross-Origin Resource Sharing)
- ✅ **JSON** (Data format)

### API Structure:
```
api/
├── config/
│   ├── database.php   (Database connection)
│   └── cors.php        (CORS configuration)
├── auth/
│   ├── login.php       (User login)
│   └── register.php    (User registration)
├── menu/
│   ├── create.php      (Create menu item)
│   └── read.php        (Get menu items)
├── orders/
│   ├── create.php      (Create order)
│   ├── read.php        (Get orders)
│   └── update_status.php (Update order status)
├── categories/
│   ├── create.php      (Create category)
│   └── read.php        (Get categories)
├── dashboard/
│   └── stats.php       (Dashboard statistics)
├── locations/
│   ├── create.php      (Create location)
│   ├── read.php        (Get locations)
│   ├── update.php      (Update location)
│   └── delete.php      (Delete location)
└── settings/
    └── read.php        (Get settings)
```

### Database:
- **MySQL/MariaDB**
- **PDO** for database operations
- Tables: `users`, `menu_items`, `categories`, `orders`, `order_items`, `locations`, `settings`, etc.

---

## 🔄 **How They Work Together:**

```
┌─────────────────┐
│  Frontend       │  (PHP + HTML + Bootstrap)
│  (Customer)     │  ──────────────┐
└─────────────────┘                 │
                                    │
┌─────────────────┐                 │
│  Admin Panel    │  (Angular 17)  │
│  (Admin)        │  ──────────────┤
└─────────────────┘                 │
                                    ▼
                            ┌──────────────┐
                            │  Backend API  │
                            │  (PHP + MySQL)│
                            └──────────────┘
```

### Communication Flow:
1. **Frontend** → Direct PHP database queries (no API calls)
2. **Admin Panel** → REST API calls → Backend PHP → MySQL
3. Both use same database but different access methods

---

## 📦 **Server Requirements:**

### For Local Development (XAMPP):
- ✅ **Apache** (Web server)
- ✅ **MySQL** (Database)
- ✅ **PHP 7.4+** (Server-side)
- ✅ **Node.js & npm** (For Angular admin - only for development)

### For Production:
- ✅ **Apache/Nginx** (Web server)
- ✅ **MySQL** (Database)
- ✅ **PHP 7.4+** (Server-side)
- ✅ **Angular Build** (Static files - no Node.js needed)

---

## 🎨 **UI/UX Libraries:**

### Frontend:
- Bootstrap 5.3.2 (CSS Framework)
- Bootstrap Icons (Icons)
- Google Fonts (Typography)
- Custom CSS (style.css)

### Admin:
- Bootstrap 5.3.2 (CSS Framework)
- Bootstrap Icons (Icons)
- Chart.js (Dashboard charts)
- Angular Material (Optional - not currently used)

---

## 📝 **Summary:**

| Component | Technology | Type |
|-----------|-----------|------|
| **Frontend** | PHP + HTML + CSS + Bootstrap | Server-side rendered |
| **Admin** | Angular 17 + TypeScript | Single Page Application (SPA) |
| **Backend** | PHP + MySQL + PDO | RESTful API |
| **Database** | MySQL | Relational Database |

---

## ✅ **Key Points:**
1. ✅ Frontend **simple HTML/CSS/Bootstrap** hai (no Angular)
2. ✅ Admin Panel **Angular 17** use karta hai
3. ✅ Backend **pure PHP** hai (no frameworks like Laravel)
4. ✅ Database **MySQL** hai
5. ✅ No complex build tools needed for frontend
6. ✅ Admin panel ke liye Angular build required hai

---

**Last Updated:** December 2025

