# 🍕 OrderFood Portal

A complete food ordering system with customer frontend (PHP + Bootstrap) and admin dashboard (Angular + MySQL).

![OrderFood Portal](https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?w=800&h=400&fit=crop)

## 📋 Features

### Customer Frontend
- 🏠 Beautiful modern homepage with hero section
- 📋 Browse menu by categories
- 🛒 Shopping cart with quantity management
- 💳 Multiple payment options (COD, Card, Online)
- 🎁 Coupon code system
- 📱 Fully responsive design
- 👤 User registration & login
- 📦 Order tracking

### Admin Dashboard
- 📊 Dashboard with statistics
- 📋 Order management with status updates
- 🍔 Menu items CRUD operations
- 📁 Categories management
- 👥 Customer management
- ⚙️ Site settings configuration

## 🛠️ Tech Stack

| Component | Technology |
|-----------|------------|
| Customer Frontend | PHP 8.0+, Bootstrap 5, JavaScript |
| Admin Dashboard | Angular 17, TypeScript, Bootstrap 5 |
| Database | MySQL 8.0+ |
| API | PHP (REST API) |

## 📁 Project Structure

```
Orderfood Portal/
├── api/                    # PHP REST API
│   ├── config/
│   │   ├── database.php
│   │   └── cors.php
│   ├── auth/
│   ├── categories/
│   ├── menu/
│   ├── orders/
│   ├── addons/
│   └── settings/
├── frontend/               # Customer Website (PHP + Bootstrap)
│   ├── includes/
│   │   ├── header.php
│   │   └── footer.php
│   ├── assets/
│   │   ├── css/
│   │   └── js/
│   ├── index.php
│   ├── menu.php
│   ├── cart.php
│   ├── checkout.php
│   └── ...
├── admin/                  # Admin Dashboard (Angular)
│   ├── src/
│   │   └── app/
│   │       ├── layouts/
│   │       ├── pages/
│   │       └── services/
│   ├── package.json
│   └── angular.json
├── database/
│   └── schema.sql
└── README.md
```

## 🚀 Installation

### Prerequisites
- PHP 8.0+ with PDO extension
- MySQL 8.0+
- Node.js 18+ (for Angular admin)
- Apache/Nginx web server
- Composer (optional)

### Step 1: Database Setup

1. Create MySQL database:
```sql
CREATE DATABASE orderfood_db;
```

2. Import the schema:
```bash
mysql -u root -p orderfood_db < database/schema.sql
```

Or import via phpMyAdmin.

### Step 2: Configure API

1. Navigate to `api/config/database.php`
2. Update database credentials:
```php
private $host = "localhost";
private $database = "orderfood_db";
private $username = "root";
private $password = "your_password";
```

### Step 3: Configure Frontend

1. Navigate to `frontend/config.php`
2. Update database credentials:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'orderfood_db');
define('DB_USER', 'root');
define('DB_PASS', 'your_password');
define('API_URL', 'http://localhost/orderfood/api');
```

### Step 4: Setup Web Server

#### For XAMPP/WAMP:
1. Copy the entire project folder to `htdocs` (XAMPP) or `www` (WAMP)
2. Rename folder to `orderfood`
3. Access frontend at: `http://localhost/orderfood/frontend/`
4. Access API at: `http://localhost/orderfood/api/`

#### For Apache Virtual Host:
```apache
<VirtualHost *:80>
    ServerName orderfood.local
    DocumentRoot /var/www/orderfood/frontend
    
    <Directory /var/www/orderfood/frontend>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

### Step 5: Setup Angular Admin

1. Navigate to admin folder:
```bash
cd admin
```

2. Install dependencies:
```bash
npm install
```

3. Update API URL in `src/app/services/api.service.ts`:
```typescript
private apiUrl = 'http://localhost/orderfood/api';
```

4. Start development server:
```bash
npm start
```

5. Access admin at: `http://localhost:4200`

## 🔑 Default Login Credentials

### Admin Panel
- **Email:** admin@orderfood.com
- **Password:** admin123

## 📝 API Endpoints

### Categories
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/categories/read.php` | Get all categories |
| POST | `/categories/create.php` | Create category |
| PUT | `/categories/update.php` | Update category |
| DELETE | `/categories/delete.php` | Delete category |

### Menu Items
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/menu/read.php` | Get all menu items |
| GET | `/menu/read.php?category_id=1` | Filter by category |
| POST | `/menu/create.php` | Create menu item |
| PUT | `/menu/update.php` | Update menu item |
| DELETE | `/menu/delete.php` | Delete menu item |

### Orders
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/orders/read.php` | Get all orders |
| GET | `/orders/read.php?id=1` | Get single order |
| POST | `/orders/create.php` | Create order |
| PUT | `/orders/update_status.php` | Update order status |

### Auth
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/auth/login.php` | User login |
| POST | `/auth/register.php` | User registration |

## 🎨 Customization

### Changing Colors
Edit CSS variables in `frontend/assets/css/style.css`:
```css
:root {
    --primary: #C41E3A;
    --primary-dark: #9A1829;
    --secondary: #D4AF37;
    /* ... */
}
```

### Adding New Categories
1. Go to Admin Dashboard → Categories
2. Click "Add Category"
3. Fill in details and save

### Adding New Menu Items
1. Go to Admin Dashboard → Menu Items
2. Click "Add Item"
3. Fill in details including category, price, etc.

## 📱 Screenshots

### Customer Frontend
- Homepage with hero section and featured items
- Menu page with category filters
- Shopping cart with order summary
- Checkout page with delivery options

### Admin Dashboard
- Dashboard with statistics and recent orders
- Orders management with status updates
- Menu items grid view with edit/delete options
- Categories management
- Settings page

## 🔧 Troubleshooting

### API CORS Issues
Make sure `api/config/cors.php` is included in all API files.

### Database Connection Failed
1. Check MySQL service is running
2. Verify database credentials
3. Ensure database exists

### Angular Build Issues
```bash
# Clear cache and reinstall
rm -rf node_modules
npm cache clean --force
npm install
```

## 📄 License

This project is open-source and available for personal and commercial use.

## 👨‍💻 Support

For support, please create an issue in the repository.

---

Made with ❤️ in Pakistan

