# 📍 Location/Branch Selection Feature

## ✅ Feature Added Successfully!

---

## 🎯 What Was Added

### 1. **Database Changes**

**New Table: `locations`**
```sql
CREATE TABLE locations (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    address TEXT NOT NULL,
    city VARCHAR(100),
    state VARCHAR(100),
    zip_code VARCHAR(20),
    country VARCHAR(100) DEFAULT 'United States',
    phone VARCHAR(20),
    email VARCHAR(100),
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

**Updated Table: `orders`**
- Added `location_id` column (INT, NULL)
- Foreign key to `locations` table

**Default Locations:**
1. Wilmington Main Branch - Wilmington, Delaware
2. Newark Branch - Newark, Delaware
3. Dover Branch - Dover, Delaware

---

### 2. **Checkout Page Updates**

**File:** `frontend/checkout.php`

**Added Location Selection:**
- Location dropdown added before Order Type
- Required field
- Shows: "Branch Name - City, State"
- Example: "Wilmington Main Branch - Wilmington, Delaware"

**Updated Order Processing:**
- `location_id` now saved with order
- Validation: Location selection is required
- Works for both Delivery and Pickup orders

---

## 📋 How It Works

### For Customers:

1. **Add items to cart**
2. **Go to checkout**
3. **Select Branch Location** (required)
   - Dropdown shows all active branches
   - Format: "Branch Name - City, State"
4. **Choose Order Type:**
   - Delivery: Order will be delivered from selected branch
   - Pickup: Order will be ready at selected branch
5. **Fill address details** (if delivery)
6. **Place order**

---

## 🔧 Setup Instructions

### Step 1: Run Database Setup

**Option A: Via Browser**
```
http://localhost/orderfood/database/setup_locations.php
```

**Option B: Via Command Line**
```bash
cd "D:\IJW\Orderfood Portal"
php database\setup_locations.php
```

**Option C: Via phpMyAdmin**
1. Open phpMyAdmin
2. Select `orderfood_db` database
3. Run SQL from `database/add_locations.sql`

---

## 📊 Database Structure

### Locations Table:
- Stores branch information
- `is_active` flag to enable/disable branches
- Full address details

### Orders Table:
- `location_id` links to selected branch
- NULL allowed for old orders

---

## 🎨 UI Changes

### Checkout Page Layout:
```
1. Contact Information
2. 📍 Select Branch Location (NEW!)
   └─ Dropdown with branches
3. Order Type (Delivery/Pickup)
4. Delivery Address (if delivery)
5. Payment Method
6. Special Instructions
```

---

## ✅ Features

- ✅ Branch selection dropdown
- ✅ Required field validation
- ✅ Works with Delivery orders
- ✅ Works with Pickup orders
- ✅ Location saved with order
- ✅ Admin can manage branches (via database)
- ✅ Fallback locations if table doesn't exist

---

## 📝 Files Modified

1. ✅ `frontend/checkout.php` - Added location selection
2. ✅ `database/add_locations.sql` - Database schema
3. ✅ `database/setup_locations.php` - Setup script

---

## 🚀 Next Steps

1. **Run setup script** to create locations table
2. **Add more branches** via database if needed
3. **Test checkout** with location selection
4. **Verify orders** save location_id correctly

---

## 💡 Admin Management

To add/edit branches, use phpMyAdmin or create admin interface:

```sql
-- Add new branch
INSERT INTO locations (name, address, city, state, zip_code, country, phone, email) 
VALUES ('Branch Name', 'Address', 'City', 'State', 'Zip', 'Country', 'Phone', 'Email');

-- Disable a branch
UPDATE locations SET is_active = 0 WHERE id = 1;

-- Enable a branch
UPDATE locations SET is_active = 1 WHERE id = 1;
```

---

**Feature is ready! Just run the setup script to activate it.** 🎉


