# 🌐 Live Server Configuration Summary

## ✅ All Files Updated for Live Server

---

## 📋 Configuration Files Updated

### 1. **Frontend Config** ✅
**File:** `frontend/config.php`

**Updated:**
```php
define('API_URL', 'http://restaurantmanager.bloomsoft.net/api');
```

**Database Config (Update on live server):**
```php
define('DB_HOST', 'localhost');  // Usually 'localhost' on live server
define('DB_NAME', 'orderfood_db');  // Your live database name
define('DB_USER', 'your_db_username');  // Your live database username
define('DB_PASS', 'your_db_password');  // Your live database password
```

---

### 2. **API Database Config** ⚠️
**File:** `api/config/database.php`

**Update on Live Server:**
```php
class Database {
    private $host = "localhost";  // Your live MySQL host
    private $database = "orderfood_db";  // Your live database name
    private $username = "your_db_username";  // Your live database username
    private $password = "your_db_password";  // Your live database password
}
```

---

### 3. **API CORS Config** ✅
**File:** `api/config/cors.php`

**Updated to allow:**
- `http://restaurantmanager.bloomsoft.net`
- `https://restaurantmanager.bloomsoft.net`
- Local development URLs (localhost)

---

### 4. **Admin Panel Config** ✅
**File:** `admin/src/environments/environment.prod.ts`

**Updated:**
```typescript
apiUrl: 'http://restaurantmanager.bloomsoft.net/api'
```

---

## 🔗 Live Server URLs

### Your Live Server Setup:
- **Frontend:** http://restaurantmanager.bloomsoft.net/frontend
- **API:** http://restaurantmanager.bloomsoft.net/api
- **Admin Panel:** http://restaurantmanager.bloomsoft.net/admin

---

## 📤 Deployment Checklist

### Frontend (Customer Website):
- [x] API URL updated in `config.php`
- [ ] Upload `frontend/` folder to server
- [ ] Update database credentials in `config.php` on live server
- [ ] Test: http://restaurantmanager.bloomsoft.net/frontend

### API (Backend):
- [x] CORS updated for live domain
- [ ] Upload `api/` folder to server
- [ ] Update database credentials in `api/config/database.php` on live server
- [ ] Test: http://restaurantmanager.bloomsoft.net/api/categories/read.php

### Admin Panel:
- [x] API URL updated in `environment.prod.ts`
- [x] Production build completed: `admin/dist/orderfood-admin/`
- [ ] Upload all files from `admin/dist/orderfood-admin/` to server
- [ ] Create `.htaccess` file in admin folder
- [ ] Test: http://restaurantmanager.bloomsoft.net/admin

---

## 🔧 Database Configuration on Live Server

### Step 1: Create Database
1. Login to cPanel/phpMyAdmin
2. Create database: `orderfood_db` (or your preferred name)
3. Create database user with password
4. Grant all privileges

### Step 2: Import Database
1. Export local database from phpMyAdmin
2. Import to live server database

### Step 3: Update Config Files
Update these 2 files on live server:

**1. `frontend/config.php`:**
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_live_db_name');
define('DB_USER', 'your_live_db_user');
define('DB_PASS', 'your_live_db_password');
```

**2. `api/config/database.php`:**
```php
private $host = "localhost";
private $database = "your_live_db_name";
private $username = "your_live_db_user";
private $password = "your_live_db_password";
```

---

## 🎯 Cart & Checkout Configuration

### ✅ Already Configured:
- Cart handler uses session (no URL changes needed)
- Checkout uses database connection (update DB config on live server)
- All cart operations work with updated API URL

### 📝 What Works:
- ✅ Add to cart
- ✅ Update cart items
- ✅ Remove from cart
- ✅ Apply coupons
- ✅ Checkout process
- ✅ Order placement
- ✅ Order tracking

---

## 🚀 Quick Deployment Steps

### 1. Upload Frontend
```
Upload: frontend/ folder
To: http://restaurantmanager.bloomsoft.net/frontend/
Update: config.php database credentials
```

### 2. Upload API
```
Upload: api/ folder
To: http://restaurantmanager.bloomsoft.net/api/
Update: api/config/database.php credentials
```

### 3. Upload Admin
```
Upload: admin/dist/orderfood-admin/* files
To: http://restaurantmanager.bloomsoft.net/admin/
Create: .htaccess file
```

### 4. Import Database
```
Export from local phpMyAdmin
Import to live server phpMyAdmin
```

---

## ✅ Configuration Status

| Component | Config File | Status | Action Needed |
|-----------|------------|--------|---------------|
| Frontend API URL | `frontend/config.php` | ✅ Updated | Update DB credentials on live |
| API CORS | `api/config/cors.php` | ✅ Updated | None |
| API Database | `api/config/database.php` | ⚠️ Needs Update | Update on live server |
| Admin API URL | `admin/environment.prod.ts` | ✅ Updated | None |
| Admin Build | `admin/dist/orderfood-admin/` | ✅ Ready | Upload to server |

---

## 🔍 Testing After Deployment

### Test Frontend:
1. Visit: http://restaurantmanager.bloomsoft.net/frontend
2. Add items to cart
3. Go to checkout
4. Place test order

### Test API:
1. Visit: http://restaurantmanager.bloomsoft.net/api/categories/read.php
2. Should return JSON data

### Test Admin:
1. Visit: http://restaurantmanager.bloomsoft.net/admin
2. Login: admin@orderfood.com / admin123
3. Check dashboard loads
4. Verify orders are visible

---

## 🆘 Common Issues

### Cart Not Working:
- Check API URL in `frontend/config.php`
- Verify API is accessible
- Check browser console for errors

### Checkout Fails:
- Verify database credentials
- Check database connection
- Check error logs

### Admin Can't Connect:
- Verify API URL in admin environment
- Check CORS settings
- Verify API is accessible

---

## 📞 Support

All configuration files are ready for live server deployment. Just update database credentials on the live server and upload files!


