# 🚀 Admin Panel Live Server Deployment Guide

## ✅ Build Complete!

Admin panel successfully built for production.

---

## 📁 Build Output Location

**Folder:** `admin/dist/orderfood-admin/`

**Files to Upload:**
- All files from `admin/dist/orderfood-admin/` folder
- Upload to: `http://restaurantmanager.bloomsoft.net/admin/` (or your admin folder)

---

## 🌐 Live Server URLs

### Your Current Setup:
- **Frontend:** http://restaurantmanager.bloomsoft.net/frontend
- **API:** http://restaurantmanager.bloomsoft.net/api
- **Admin Panel:** http://restaurantmanager.bloomsoft.net/admin (after upload)

---

## 📤 Step-by-Step Upload Instructions

### Step 1: Access Your Server
1. Login to your hosting control panel (cPanel, FTP, etc.)
2. Navigate to your website root directory

### Step 2: Create Admin Folder (if not exists)
- Create folder: `admin` (or use existing)
- Path: `/public_html/admin/` or `/www/admin/` (depends on your hosting)

### Step 3: Upload Files
Upload **ALL files** from:
```
D:\IJW\Orderfood Portal\admin\dist\orderfood-admin\*
```

To your server:
```
http://restaurantmanager.bloomsoft.net/admin/
```

### Step 4: Set Permissions
- Folders: 755
- Files: 644

### Step 5: Create .htaccess (for Angular routing)
Create file: `admin/.htaccess`

```apache
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /admin/
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteRule . /admin/index.html [L]
</IfModule>
```

---

## 🔗 Admin Panel Access

### After Upload:
**Admin Dashboard URL:**
```
http://restaurantmanager.bloomsoft.net/admin
```

**Admin Login URL:**
```
http://restaurantmanager.bloomsoft.net/admin/login
```

### Login Credentials:
- **Email:** admin@orderfood.com
- **Password:** admin123

---

## ⚙️ Configuration Already Updated

✅ **API URL** already configured in `environment.prod.ts`:
```typescript
apiUrl: 'http://restaurantmanager.bloomsoft.net/api'
```

✅ **Build** completed successfully

---

## 📋 Upload Checklist

- [ ] Access server via FTP/cPanel
- [ ] Create/verify `admin` folder exists
- [ ] Upload all files from `admin/dist/orderfood-admin/` to server
- [ ] Create `.htaccess` file in admin folder
- [ ] Set correct file permissions (755 for folders, 644 for files)
- [ ] Test admin panel: http://restaurantmanager.bloomsoft.net/admin
- [ ] Test login functionality
- [ ] Verify API connection works

---

## 🆘 Troubleshooting

### Admin Panel Shows Blank Page
- Check browser console for errors
- Verify `.htaccess` file is uploaded
- Check file permissions
- Verify all files are uploaded

### API Connection Failed
- Verify API URL in `environment.prod.ts` is correct
- Check `api/config/database.php` has correct database credentials
- Check CORS settings in `api/config/cors.php`

### 404 Error on Routes
- Ensure `.htaccess` file is in admin folder
- Check mod_rewrite is enabled on server
- Verify base href in `index.html`

### CORS Errors
- Update `api/config/cors.php` to allow your domain:
```php
header("Access-Control-Allow-Origin: http://restaurantmanager.bloomsoft.net");
```

---

## 📁 File Structure on Server

```
restaurantmanager.bloomsoft.net/
├── frontend/          (Your customer website)
├── api/               (PHP API)
│   └── config/
│       └── database.php
└── admin/             (Angular Admin Panel - Upload here)
    ├── index.html
    ├── .htaccess
    ├── styles-*.css
    ├── main-*.js
    └── ... (all other build files)
```

---

## ✅ After Deployment

1. **Test Admin Login:**
   - Go to: http://restaurantmanager.bloomsoft.net/admin/login
   - Login with: admin@orderfood.com / admin123

2. **Test Dashboard:**
   - Verify statistics load correctly
   - Check orders are visible

3. **Test API Connection:**
   - Open browser console (F12)
   - Check for any API errors

---

## 🎯 Quick Summary

1. ✅ Build completed: `admin/dist/orderfood-admin/`
2. 📤 Upload all files to: `http://restaurantmanager.bloomsoft.net/admin/`
3. 🔗 Access admin: `http://restaurantmanager.bloomsoft.net/admin`
4. 🔐 Login: admin@orderfood.com / admin123

---

**Need Help?** Check the troubleshooting section above or verify your server configuration.


