# 📋 Database Configuration Guide - Live Server Setup

## 🔧 Configuration Files Location

### 1. Frontend Configuration
**File:** `frontend/config.php`

**Lines to Change:**
```php
// Database Configuration
define('DB_HOST', 'localhost');        // Change to your live server host
define('DB_NAME', 'orderfood_db');     // Change to your live database name
define('DB_USER', 'root');             // Change to your live database username
define('DB_PASS', '');                 // Change to your live database password

// API URL (if API is on different domain)
define('API_URL', 'http://localhost/orderfood/api');  // Change to your live API URL
```

### 2. Backend API Configuration
**File:** `api/config/database.php`

**Lines to Change:**
```php
class Database {
    private $host = "localhost";           // Change to your live server host
    private $database = "orderfood_db";    // Change to your live database name
    private $username = "root";            // Change to your live database username
    private $password = "";                 // Change to your live database password
}
```

---

## 🌐 Live Server Example Configuration

### Example 1: cPanel / Shared Hosting
```php
// frontend/config.php
define('DB_HOST', 'localhost');  // Usually 'localhost' on cPanel
define('DB_NAME', 'username_orderfood_db');  // cPanel format: username_dbname
define('DB_USER', 'username_dbuser');        // cPanel database user
define('DB_PASS', 'your_secure_password');   // Database password
define('API_URL', 'https://yourdomain.com/api');  // Your live domain

// api/config/database.php
private $host = "localhost";
private $database = "username_orderfood_db";
private $username = "username_dbuser";
private $password = "your_secure_password";
```

### Example 2: VPS / Dedicated Server
```php
// frontend/config.php
define('DB_HOST', 'localhost');  // or your MySQL server IP
define('DB_NAME', 'orderfood_db');
define('DB_USER', 'orderfood_user');
define('DB_PASS', 'StrongPassword123!');
define('API_URL', 'https://yourdomain.com/api');

// api/config/database.php
private $host = "localhost";
private $database = "orderfood_db";
private $username = "orderfood_user";
private $password = "StrongPassword123!";
```

### Example 3: Cloud Hosting (AWS, DigitalOcean, etc.)
```php
// frontend/config.php
define('DB_HOST', 'your-db-host.amazonaws.com');  // RDS endpoint
define('DB_NAME', 'orderfood_db');
define('DB_USER', 'admin');
define('DB_PASS', 'your-secure-password');
define('API_URL', 'https://api.yourdomain.com');

// api/config/database.php
private $host = "your-db-host.amazonaws.com";
private $database = "orderfood_db";
private $username = "admin";
private $password = "your-secure-password";
```

---

## 📝 Step-by-Step Instructions

### Step 1: Create Database on Live Server
1. Login to your hosting control panel (cPanel, Plesk, etc.)
2. Go to MySQL Databases
3. Create a new database (e.g., `orderfood_db`)
4. Create a database user with password
5. Grant all privileges to the user on the database

### Step 2: Import Database
1. Export your local database (from phpMyAdmin)
2. Import it to your live server database

### Step 3: Update Configuration Files
1. Edit `frontend/config.php` - Update lines 17-20
2. Edit `api/config/database.php` - Update lines 8-11
3. Update `API_URL` in `frontend/config.php` if needed

### Step 4: Upload Files
1. Upload all files to your live server
2. Make sure file permissions are correct (755 for folders, 644 for files)

### Step 5: Test Connection
1. Visit your website
2. Check if database connection works
3. Test placing an order

---

## ⚠️ Important Notes

1. **Security:** Never commit database passwords to Git
2. **Backup:** Always backup your database before making changes
3. **SSL:** Use HTTPS on live server for security
4. **Permissions:** Check file permissions on live server
5. **PHP Version:** Ensure PHP 7.4+ is installed on live server

---

## 🔒 Security Best Practices

1. Use strong database passwords
2. Don't use 'root' user in production
3. Create a dedicated database user with limited privileges
4. Use environment variables for sensitive data (optional)
5. Enable SSL/HTTPS for your website

---

## 📞 Quick Checklist

- [ ] Database created on live server
- [ ] Database user created with password
- [ ] Database imported successfully
- [ ] `frontend/config.php` updated
- [ ] `api/config/database.php` updated
- [ ] API_URL updated (if different domain)
- [ ] Files uploaded to live server
- [ ] Tested database connection
- [ ] Tested order placement

---

## 🆘 Troubleshooting

### Connection Failed Error
- Check database credentials
- Verify database host (might not be 'localhost')
- Check if MySQL service is running
- Verify firewall settings

### Access Denied Error
- Check database username and password
- Verify user has privileges on the database
- Check if user is allowed to connect from your server IP

### Database Not Found
- Verify database name is correct
- Check if database exists on server
- Ensure database was imported successfully


