# 🔧 Admin Dashboard Connection Fix

## ❌ Connection Failed Error - Solution

---

## 🔍 Problem Diagnosis

**Error:** "Connection failed" in Admin Dashboard

**Possible Causes:**
1. Angular dev server not running
2. API connection issue
3. CORS configuration problem
4. Port 4200 not accessible

---

## ✅ Solutions

### **Solution 1: Start Angular Dev Server**

**Step 1:** Open PowerShell in admin folder
```powershell
cd "D:\IJW\Orderfood Portal\admin"
```

**Step 2:** Start Angular dev server
```powershell
npm start
```

**Step 3:** Wait for compilation (30-60 seconds)
- Look for: "✔ Compiled successfully"
- Look for: "Local: http://localhost:4200/"

**Step 4:** Open browser
```
http://localhost:4200
```

---

### **Solution 2: Check API Connection**

**API URL:** `http://localhost/orderfood/api`

**Test API:**
```powershell
Invoke-WebRequest -Uri "http://localhost/orderfood/api/dashboard/stats.php"
```

**Expected:** Status 200 OK

---

### **Solution 3: Verify Environment Configuration**

**File:** `admin/src/environments/environment.ts`

**Should be:**
```typescript
export const environment = {
  production: false,
  apiUrl: 'http://localhost/orderfood/api'
};
```

---

### **Solution 4: Check CORS Settings**

**File:** `api/config/cors.php`

**Should include:**
```php
$allowed_origins = [
    'http://localhost:4200',  // Local admin development
    'http://localhost'  // Local frontend development
];
```

---

### **Solution 5: Restart Services**

1. **Stop Angular Dev Server:**
   - Press `Ctrl + C` in terminal
   - Or close PowerShell window

2. **Restart Apache (XAMPP):**
   - Open XAMPP Control Panel
   - Stop Apache
   - Start Apache

3. **Restart Angular:**
   ```powershell
   cd "D:\IJW\Orderfood Portal\admin"
   npm start
   ```

---

## 🚀 Quick Fix Commands

### **Start Everything:**
```powershell
# 1. Check Apache
# Open XAMPP Control Panel → Start Apache

# 2. Start Angular
cd "D:\IJW\Orderfood Portal\admin"
npm start
```

### **Check Status:**
```powershell
# Check Apache (port 80)
netstat -an | Select-String ":80"

# Check Angular (port 4200)
netstat -an | Select-String ":4200"

# Test API
Invoke-WebRequest -Uri "http://localhost/orderfood/api/dashboard/stats.php"
```

---

## 📋 Verification Checklist

- [ ] Apache running (XAMPP Control Panel - Green)
- [ ] MySQL running (XAMPP Control Panel - Green)
- [ ] Angular dev server running (PowerShell - "Compiled successfully")
- [ ] Port 4200 accessible (http://localhost:4200)
- [ ] API accessible (http://localhost/orderfood/api)
- [ ] CORS configured correctly
- [ ] Environment.ts has correct API URL

---

## 🎯 Current Status

✅ **API Connection:** Working (Status 200)
✅ **CORS Configuration:** Correct
✅ **Environment Config:** Correct
⏳ **Angular Dev Server:** Starting...

---

## 💡 If Still Not Working

1. **Clear Browser Cache:**
   - Press `Ctrl + Shift + Delete`
   - Clear cached files

2. **Hard Refresh:**
   - Press `Ctrl + F5`

3. **Check Firewall:**
   - Allow Node.js through firewall
   - Allow Apache through firewall

4. **Check Port Conflicts:**
   - Port 4200 should be free
   - Port 80 should be free

---

**Angular dev server ab start ho raha hai. Thoda wait karo (30-60 seconds) phir browser mein `http://localhost:4200` kholo.**


