# 🔧 Admin Panel Configuration Guide

## 📍 Admin Database Configuration Location

### ⚠️ Important Note:
**Admin panel (Angular) does NOT connect directly to database!**

The admin panel connects to the **PHP API**, which then connects to the database.

---

## 🔗 Configuration Files

### 1. **Admin API URL Configuration**
**File:** `admin/src/environments/environment.ts` (Development)
**File:** `admin/src/environments/environment.prod.ts` (Production)

**Current Configuration:**
```typescript
// environment.ts (Development)
export const environment = {
  production: false,
  apiUrl: 'http://localhost/orderfood/api'
};

// environment.prod.ts (Production)
export const environment = {
  production: true,
  apiUrl: 'https://yourdomain.com/api'  // ← Change this for live server
};
```

### 2. **API Database Configuration**
**File:** `api/config/database.php`

This is where the actual database connection happens. The admin panel uses this API.

```php
class Database {
    private $host = "localhost";           // ← Live server host
    private $database = "orderfood_db";     // ← Live database name
    private $username = "root";            // ← Live database username
    private $password = "";                 // ← Live database password
}
```

---

## 🌐 Live Server Setup

### Step 1: Update API Database Config
Edit `api/config/database.php`:
```php
private $host = "localhost";  // or your MySQL host
private $database = "your_live_db_name";
private $username = "your_db_username";
private $password = "your_db_password";
```

### Step 2: Update Admin API URL
Edit `admin/src/environments/environment.prod.ts`:
```typescript
export const environment = {
  production: true,
  apiUrl: 'https://yourdomain.com/api'  // Your live API URL
};
```

### Step 3: Build Admin for Production
```bash
cd admin
npm run build --configuration=production
```

This will create optimized files in `admin/dist/orderfood-admin/` folder.

### Step 4: Upload Files
- Upload `admin/dist/orderfood-admin/*` to your live server
- Upload `api/*` folder to your live server
- Upload `frontend/*` folder to your live server

---

## 📝 Complete Configuration Summary

### For Live Server, Update These 3 Files:

1. **`api/config/database.php`** (Lines 8-11)
   - Database host, name, username, password

2. **`admin/src/environments/environment.prod.ts`** (Line 3)
   - API URL for production

3. **`frontend/config.php`** (Lines 17-20, 14)
   - Database config and API URL

---

## 🚀 Quick Example for Live Server

### cPanel/Shared Hosting Example:

**1. API Database Config** (`api/config/database.php`):
```php
private $host = "localhost";
private $database = "username_orderfood_db";
private $username = "username_dbuser";
private $password = "secure_password_123";
```

**2. Admin API URL** (`admin/src/environments/environment.prod.ts`):
```typescript
export const environment = {
  production: true,
  apiUrl: 'https://yourdomain.com/api'
};
```

**3. Frontend Config** (`frontend/config.php`):
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'username_orderfood_db');
define('DB_USER', 'username_dbuser');
define('DB_PASS', 'secure_password_123');
define('API_URL', 'https://yourdomain.com/api');
```

---

## ⚡ Build Commands

### Development (Local):
```bash
cd admin
npm start
# Uses: environment.ts (http://localhost/orderfood/api)
```

### Production (Live Server):
```bash
cd admin
npm run build --configuration=production
# Uses: environment.prod.ts (https://yourdomain.com/api)
```

---

## 🔍 How It Works

```
Admin Panel (Angular)
    ↓ (HTTP Request)
PHP API (api/config/database.php)
    ↓ (PDO Connection)
MySQL Database
```

**Admin Panel** → **API** → **Database**

The admin panel never directly connects to the database. All database operations go through the PHP API.

---

## ✅ Checklist for Live Deployment

- [ ] Update `api/config/database.php` with live database credentials
- [ ] Update `admin/src/environments/environment.prod.ts` with live API URL
- [ ] Update `frontend/config.php` with live database credentials and API URL
- [ ] Build admin panel: `npm run build --configuration=production`
- [ ] Upload `admin/dist/orderfood-admin/*` to live server
- [ ] Upload `api/*` folder to live server
- [ ] Upload `frontend/*` folder to live server
- [ ] Test admin login
- [ ] Test API endpoints
- [ ] Test order placement from frontend

---

## 🆘 Troubleshooting

### Admin Panel Can't Connect to API
- Check `environment.prod.ts` API URL
- Verify API is accessible on live server
- Check CORS settings in `api/config/cors.php`

### API Can't Connect to Database
- Check `api/config/database.php` credentials
- Verify database exists on live server
- Check MySQL service is running
- Verify user has proper permissions

### CORS Errors
- Update `api/config/cors.php` to allow your live domain
- Check if API URL in admin matches actual API location


